/**************************************************************************
 *** The Tab-delimited file specified in the FILENAME statement below   ***
 *** may not reflect the location of the data file on your computer.    ***
 *** You may need to modify the code to refelect the location of the    ***
 *** data file on your computer.                                        ***
 ***                                                                    ***
 *** The SAS code below was written for SAS v9.1 or above. Labels were  ***
 *** given a maximun length of 60 characters. If you are using SAS v7   ***
 *** or below, you should be aware that labels could be truncated to 40 ***
 *** characters. If so, you may wish to abbreviate labels so that they  ***
 *** are unique and are descriptive.                                    ***
 ***                                                                    ***
 *** This program provides code to generate one-way frequency tables    ***
 *** for all categorical variables. You will need to uncomment the      ***
 *** frequency section to generate frequency tables.                    ***
 ***                                                                    ***
 *** There may be missing data for some institutions due to parent-     ***
 *** child relations.                                                   ***
 **************************************************************************/

/* Specify location of ASCII dataset */
filename inptfile "C:\NCES\PSS1112\pss1112_pu.txt";

/* Read ASCII data */
data pss1112_pu;
   infile inptfile delimiter='09'x missover dsd lrecl=32767 firstobs=2;
   missing M N;
   informat pfnlwt best32. repw1 best32. repw2 best32. repw3 best32. repw4
            best32. repw5 best32. repw6 best32. repw7 best32. repw8 best32.
            repw9 best32. repw10 best32. repw11 best32. repw12 best32. repw13
            best32. repw14 best32. repw15 best32. repw16 best32. repw17 best32.
            repw18 best32. repw19 best32. repw20 best32. repw21 best32. repw22
            best32. repw23 best32. repw24 best32. repw25 best32. repw26 best32.
            repw27 best32. repw28 best32. repw29 best32. repw30 best32. repw31
            best32. repw32 best32. repw33 best32. repw34 best32. repw35 best32.
            repw36 best32. repw37 best32. repw38 best32. repw39 best32. repw40
            best32. repw41 best32. repw42 best32. repw43 best32. repw44 best32.
            repw45 best32. repw46 best32. repw47 best32. repw48 best32. repw49
            best32. repw50 best32. repw51 best32. repw52 best32. repw53 best32.
            repw54 best32. repw55 best32. repw56 best32. repw57 best32. repw58
            best32. repw59 best32. repw60 best32. repw61 best32. repw62 best32.
            repw63 best32. repw64 best32. repw65 best32. repw66 best32. repw67
            best32. repw68 best32. repw69 best32. repw70 best32. repw71 best32.
            repw72 best32. repw73 best32. repw74 best32. repw75 best32. repw76
            best32. repw77 best32. repw78 best32. repw79 best32. repw80 best32.
            repw81 best32. repw82 best32. repw83 best32. repw84 best32. repw85
            best32. repw86 best32. repw87 best32. repw88 best32. csource
            best32. p135 best32. p140 best32. p145 best32. p150 best32. p155
            best32. p160 best32. p165 best32. p170 best32. p175 best32. p180
            best32. p185 best32. p190 best32. p195 best32. p200 best32. p205
            best32. p210 best32. p215 best32. p220 best32. p225 best32. p230
            best32. p235 best32. p240 best32. p245 best32. p250 best32. p255
            best32. p260 best32. p265 best32. p270 best32. p275 best32. p280
            best32. p285 best32. p290 best32. p295 best32. p300 best32. p305
            best32. p320 best32. p330 best32. p325 best32. p316 best32. p318
            best32. p310 best32. p332 best32. p335 best32. p340 best32. p345
            best32. p350 best32. p360 best32. p365 best32. p370 best32. p385
            best32. p390 best32. p395 best32. p400 best32. p405 best32. p410
            best32. p415 best32. p420 best32. p425 best32. p430 best32. p435
            best32. p440 best32. p445 best32. p450 best32. p455 best32. p460
            best32. p465 best32. p467 best32. p468 best32. p470 best32. p480
            best32. p485 best32. p490 best32. p492 best32. p495 best32. p500
            best32. p505 best32. p510 best32. p515 best32. p520 best32. p522
            best32. p525 best32. p530 best32. p535 best32. p540 best32. p542
            best32. p545 best32. p550 best32. p555 best32. p575 best32. p580
            best32. p585 best32. p590 best32. p600 best32. p602 best32. p605
            best32. p610 best32. p620 best32. p622 best32. p625 best32. p630
            best32. p635 best32. p640 best32. p645 best32. p650 best32. p655
            best32. p660 best32. p665 best32. ppin $8. pinst $50. paddrs $50.
            pcity $28. pstabb $2. pzip $5. pzip4 $4. pcnty $3. pcntnm $40.
            pl_add $50. pl_cit $28. pl_stabb $2. pl_zip $5. pl_zip4 $4. region
            best32. pstansi best32. ulocale12 best32. latitude12 best32.
            longitude12 best32. logr2012 best32. higr2012 best32. frame $4.
            tabflag best32. typology best32. relig best32. orient best32.
            diocese best32. level best32. numstuds best32. size best32.
            numteach best32. ucommtyp best32. tothrs best32. males best32.
            f_p135 best32. f_p140 best32. f_p145 best32. f_p150 best32. f_p155
            best32. f_p160 best32. f_p165 best32. f_p170 best32. f_p175 best32.
            f_p180 best32. f_p185 best32. f_p190 best32. f_p195 best32. f_p200
            best32. f_p205 best32. f_p210 best32. f_p215 best32. f_p220 best32.
            f_p225 best32. f_p230 best32. f_p235 best32. f_p240 best32. f_p245
            best32. f_p250 best32. f_p255 best32. f_p260 best32. f_p265 best32.
            f_p270 best32. f_p275 best32. f_p280 best32. f_p285 best32. f_p290
            best32. f_p295 best32. f_p300 best32. f_p305 best32. f_p310 best32.
            f_p316 best32. f_p318 best32. f_p320 best32. f_p325 best32. f_p330
            best32. f_p332 best32. f_p335 best32. f_p340 best32. f_p345 best32.
            f_p350 best32. f_p360 best32. f_p365 best32. f_p370 best32. f_p385
            best32. f_p390 best32. f_p395 best32. f_p400 best32. f_p405 best32.
            f_p410 best32. f_p415 best32. f_p420 best32. f_p425 best32. f_p430
            best32. f_p435 best32. f_p440 best32. f_p445 best32. f_p450 best32.
            f_p455 best32. f_p460 best32. f_p465 best32. f_p467 best32. f_p468
            best32. f_p470 best32. f_p480 best32. f_p485 best32. f_p490 best32.
            f_p492 best32. f_p495 best32. f_p500 best32. f_p505 best32. f_p510
            best32. f_p515 best32. f_p520 best32. f_p522 best32. f_p525 best32.
            f_p530 best32. f_p535 best32. f_p540 best32. f_p542 best32. f_p545
            best32. f_p550 best32. f_p555 best32. f_p575 best32. f_p580 best32.
            f_p585 best32. f_p590 best32. f_p600 best32. f_p602 best32. f_p605
            best32. f_p610 best32. f_p620 best32. f_p622 best32. f_p625 best32.
            f_p630 best32. f_p635 best32. f_p640 best32. f_p645 best32. f_p650
            best32. f_p655 best32. f_p660 best32. s_kg best32. p_indian best32.
            p_asian best32. p_pacific best32. p_hisp best32. p_white best32.
            p_black best32. p_tr best32. sttch_rt best32.;
   format pfnlwt best32. repw1 best32. repw2 best32. repw3 best32. repw4
          best32. repw5 best32. repw6 best32. repw7 best32. repw8 best32.
          repw9 best32. repw10 best32. repw11 best32. repw12 best32. repw13
          best32. repw14 best32. repw15 best32. repw16 best32. repw17 best32.
          repw18 best32. repw19 best32. repw20 best32. repw21 best32. repw22
          best32. repw23 best32. repw24 best32. repw25 best32. repw26 best32.
          repw27 best32. repw28 best32. repw29 best32. repw30 best32. repw31
          best32. repw32 best32. repw33 best32. repw34 best32. repw35 best32.
          repw36 best32. repw37 best32. repw38 best32. repw39 best32. repw40
          best32. repw41 best32. repw42 best32. repw43 best32. repw44 best32.
          repw45 best32. repw46 best32. repw47 best32. repw48 best32. repw49
          best32. repw50 best32. repw51 best32. repw52 best32. repw53 best32.
          repw54 best32. repw55 best32. repw56 best32. repw57 best32. repw58
          best32. repw59 best32. repw60 best32. repw61 best32. repw62 best32.
          repw63 best32. repw64 best32. repw65 best32. repw66 best32. repw67
          best32. repw68 best32. repw69 best32. repw70 best32. repw71 best32.
          repw72 best32. repw73 best32. repw74 best32. repw75 best32. repw76
          best32. repw77 best32. repw78 best32. repw79 best32. repw80 best32.
          repw81 best32. repw82 best32. repw83 best32. repw84 best32. repw85
          best32. repw86 best32. repw87 best32. repw88 best32. csource
          best32. p135 best32. p140 best32. p145 best32. p150 best32. p155
          best32. p160 best32. p165 best32. p170 best32. p175 best32. p180
          best32. p185 best32. p190 best32. p195 best32. p200 best32. p205
          best32. p210 best32. p215 best32. p220 best32. p225 best32. p230
          best32. p235 best32. p240 best32. p245 best32. p250 best32. p255
          best32. p260 best32. p265 best32. p270 best32. p275 best32. p280
          best32. p285 best32. p290 best32. p295 best32. p300 best32. p305
          best32. p320 best32. p330 best32. p325 best32. p316 best32. p318
          best32. p310 best32. p332 best32. p335 best32. p340 best32. p345
          best32. p350 best32. p360 best32. p365 best32. p370 best32. p385
          best32. p390 best32. p395 best32. p400 best32. p405 best32. p410
          best32. p415 best32. p420 best32. p425 best32. p430 best32. p435
          best32. p440 best32. p445 best32. p450 best32. p455 best32. p460
          best32. p465 best32. p467 best32. p468 best32. p470 best32. p480
          best32. p485 best32. p490 best32. p492 best32. p495 best32. p500
          best32. p505 best32. p510 best32. p515 best32. p520 best32. p522
          best32. p525 best32. p530 best32. p535 best32. p540 best32. p542
          best32. p545 best32. p550 best32. p555 best32. p575 best32. p580
          best32. p585 best32. p590 best32. p600 best32. p602 best32. p605
          best32. p610 best32. p620 best32. p622 best32. p625 best32. p630
          best32. p635 best32. p640 best32. p645 best32. p650 best32. p655
          best32. p660 best32. p665 best32. ppin $8. pinst $50. paddrs $50.
          pcity $28. pstabb $2. pzip $5. pzip4 $4. pcnty $3. pcntnm $40.
          pl_add $50. pl_cit $28. pl_stabb $2. pl_zip $5. pl_zip4 $4. region
          best32. pstansi best32. ulocale12 best32. latitude12 best32.
          longitude12 best32. logr2012 best32. higr2012 best32. frame $4.
          tabflag best32. typology best32. relig best32. orient best32.
          diocese best32. level best32. numstuds best32. size best32.
          numteach best32. ucommtyp best32. tothrs best32. males best32.
          f_p135 best32. f_p140 best32. f_p145 best32. f_p150 best32. f_p155
          best32. f_p160 best32. f_p165 best32. f_p170 best32. f_p175 best32.
          f_p180 best32. f_p185 best32. f_p190 best32. f_p195 best32. f_p200
          best32. f_p205 best32. f_p210 best32. f_p215 best32. f_p220 best32.
          f_p225 best32. f_p230 best32. f_p235 best32. f_p240 best32. f_p245
          best32. f_p250 best32. f_p255 best32. f_p260 best32. f_p265 best32.
          f_p270 best32. f_p275 best32. f_p280 best32. f_p285 best32. f_p290
          best32. f_p295 best32. f_p300 best32. f_p305 best32. f_p310 best32.
          f_p316 best32. f_p318 best32. f_p320 best32. f_p325 best32. f_p330
          best32. f_p332 best32. f_p335 best32. f_p340 best32. f_p345 best32.
          f_p350 best32. f_p360 best32. f_p365 best32. f_p370 best32. f_p385
          best32. f_p390 best32. f_p395 best32. f_p400 best32. f_p405 best32.
          f_p410 best32. f_p415 best32. f_p420 best32. f_p425 best32. f_p430
          best32. f_p435 best32. f_p440 best32. f_p445 best32. f_p450 best32.
          f_p455 best32. f_p460 best32. f_p465 best32. f_p467 best32. f_p468
          best32. f_p470 best32. f_p480 best32. f_p485 best32. f_p490 best32.
          f_p492 best32. f_p495 best32. f_p500 best32. f_p505 best32. f_p510
          best32. f_p515 best32. f_p520 best32. f_p522 best32. f_p525 best32.
          f_p530 best32. f_p535 best32. f_p540 best32. f_p542 best32. f_p545
          best32. f_p550 best32. f_p555 best32. f_p575 best32. f_p580 best32.
          f_p585 best32. f_p590 best32. f_p600 best32. f_p602 best32. f_p605
          best32. f_p610 best32. f_p620 best32. f_p622 best32. f_p625 best32.
          f_p630 best32. f_p635 best32. f_p640 best32. f_p645 best32. f_p650
          best32. f_p655 best32. f_p660 best32. s_kg best32. p_indian best32.
          p_asian best32. p_pacific best32. p_hisp best32. p_white best32.
          p_black best32. p_tr best32. sttch_rt best32.;
   input
      pfnlwt
      repw1
      repw2
      repw3
      repw4
      repw5
      repw6
      repw7
      repw8
      repw9
      repw10
      repw11
      repw12
      repw13
      repw14
      repw15
      repw16
      repw17
      repw18
      repw19
      repw20
      repw21
      repw22
      repw23
      repw24
      repw25
      repw26
      repw27
      repw28
      repw29
      repw30
      repw31
      repw32
      repw33
      repw34
      repw35
      repw36
      repw37
      repw38
      repw39
      repw40
      repw41
      repw42
      repw43
      repw44
      repw45
      repw46
      repw47
      repw48
      repw49
      repw50
      repw51
      repw52
      repw53
      repw54
      repw55
      repw56
      repw57
      repw58
      repw59
      repw60
      repw61
      repw62
      repw63
      repw64
      repw65
      repw66
      repw67
      repw68
      repw69
      repw70
      repw71
      repw72
      repw73
      repw74
      repw75
      repw76
      repw77
      repw78
      repw79
      repw80
      repw81
      repw82
      repw83
      repw84
      repw85
      repw86
      repw87
      repw88
      csource
      p135
      p140
      p145
      p150
      p155
      p160
      p165
      p170
      p175
      p180
      p185
      p190
      p195
      p200
      p205
      p210
      p215
      p220
      p225
      p230
      p235
      p240
      p245
      p250
      p255
      p260
      p265
      p270
      p275
      p280
      p285
      p290
      p295
      p300
      p305
      p320
      p330
      p325
      p316
      p318
      p310
      p332
      p335
      p340
      p345
      p350
      p360
      p365
      p370
      p385
      p390
      p395
      p400
      p405
      p410
      p415
      p420
      p425
      p430
      p435
      p440
      p445
      p450
      p455
      p460
      p465
      p467
      p468
      p470
      p480
      p485
      p490
      p492
      p495
      p500
      p505
      p510
      p515
      p520
      p522
      p525
      p530
      p535
      p540
      p542
      p545
      p550
      p555
      p575
      p580
      p585
      p590
      p600
      p602
      p605
      p610
      p620
      p622
      p625
      p630
      p635
      p640
      p645
      p650
      p655
      p660
      p665
      ppin $
      pinst $
      paddrs $
      pcity $
      pstabb $
      pzip $
      pzip4 $
      pcnty $
      pcntnm $
      pl_add $
      pl_cit $
      pl_stabb $
      pl_zip $
      pl_zip4 $
      region
      pstansi
      ulocale12
      latitude12
      longitude12
      logr2012
      higr2012
      frame $
      tabflag
      typology
      relig
      orient
      diocese
      level
      numstuds
      size
      numteach
      ucommtyp
      tothrs
      males
      f_p135
      f_p140
      f_p145
      f_p150
      f_p155
      f_p160
      f_p165
      f_p170
      f_p175
      f_p180
      f_p185
      f_p190
      f_p195
      f_p200
      f_p205
      f_p210
      f_p215
      f_p220
      f_p225
      f_p230
      f_p235
      f_p240
      f_p245
      f_p250
      f_p255
      f_p260
      f_p265
      f_p270
      f_p275
      f_p280
      f_p285
      f_p290
      f_p295
      f_p300
      f_p305
      f_p310
      f_p316
      f_p318
      f_p320
      f_p325
      f_p330
      f_p332
      f_p335
      f_p340
      f_p345
      f_p350
      f_p360
      f_p365
      f_p370
      f_p385
      f_p390
      f_p395
      f_p400
      f_p405
      f_p410
      f_p415
      f_p420
      f_p425
      f_p430
      f_p435
      f_p440
      f_p445
      f_p450
      f_p455
      f_p460
      f_p465
      f_p467
      f_p468
      f_p470
      f_p480
      f_p485
      f_p490
      f_p492
      f_p495
      f_p500
      f_p505
      f_p510
      f_p515
      f_p520
      f_p522
      f_p525
      f_p530
      f_p535
      f_p540
      f_p542
      f_p545
      f_p550
      f_p555
      f_p575
      f_p580
      f_p585
      f_p590
      f_p600
      f_p602
      f_p605
      f_p610
      f_p620
      f_p622
      f_p625
      f_p630
      f_p635
      f_p640
      f_p645
      f_p650
      f_p655
      f_p660
      s_kg
      p_indian
      p_asian
      p_pacific
      p_hisp
      p_white
      p_black
      p_tr
      sttch_rt;

   /* Create variable labels */
   label csource     = "Method of Interview"
         diocese     = "Diocese or archdiocese"
         f_p135      = "Imputation Flag For P135"
         f_p140      = "Imputation Flag For P140"
         f_p145      = "Imputation Flag For P145"
         f_p150      = "Imputation Flag For P150"
         f_p155      = "Imputation Flag For P155"
         f_p160      = "Imputation Flag For P160"
         f_p165      = "Imputation Flag For P165"
         f_p170      = "Imputation Flag For P170"
         f_p175      = "Imputation Flag For P175"
         f_p180      = "Imputation Flag For P180"
         f_p185      = "Imputation Flag For P185"
         f_p190      = "Imputation Flag For P190"
         f_p195      = "Imputation Flag For P195"
         f_p200      = "Imputation Flag For P200"
         f_p205      = "Imputation Flag For P205"
         f_p210      = "Imputation Flag For P210"
         f_p215      = "Imputation Flag For P215"
         f_p220      = "Imputation Flag For P220"
         f_p225      = "Imputation Flag For P225"
         f_p230      = "Imputation Flag For P230"
         f_p235      = "Imputation Flag For P235"
         f_p240      = "Imputation Flag For P240"
         f_p245      = "Imputation Flag For P245"
         f_p250      = "Imputation Flag For P250"
         f_p255      = "Imputation Flag For P255"
         f_p260      = "Imputation Flag For P260"
         f_p265      = "Imputation Flag For P265"
         f_p270      = "Imputation Flag For P270"
         f_p275      = "Imputation Flag For P275"
         f_p280      = "Imputation Flag For P280"
         f_p285      = "Imputation Flag For P285"
         f_p290      = "Imputation Flag For P290"
         f_p295      = "Imputation Flag For P295"
         f_p300      = "Imputation Flag For P300"
         f_p305      = "Imputation Flag For P305"
         f_p310      = "Imputation Flag For P310"
         f_p316      = "Imputation Flag For P316"
         f_p318      = "Imputation Flag For P318"
         f_p320      = "Imputation Flag For P320"
         f_p325      = "Imputation Flag For P325"
         f_p330      = "Imputation Flag For P330"
         f_p332      = "Imputation Flag For P332"
         f_p335      = "Imputation Flag For P335"
         f_p340      = "Imputation Flag For P340"
         f_p345      = "Imputation Flag For P345"
         f_p350      = "Imputation Flag For P350"
         f_p360      = "Imputation Flag For P360"
         f_p365      = "Imputation Flag For P365"
         f_p370      = "Imputation Flag For P370"
         f_p385      = "Imputation Flag For P385"
         f_p390      = "Imputation Flag For P390"
         f_p395      = "Imputation Flag For P395"
         f_p400      = "Imputation Flag For P400"
         f_p405      = "Imputation Flag For P405"
         f_p410      = "Imputation Flag For P410"
         f_p415      = "Imputation Flag For P415"
         f_p420      = "Imputation Flag For P420"
         f_p425      = "Imputation Flag For P425"
         f_p430      = "Imputation Flag For P430"
         f_p435      = "Imputation Flag For P435"
         f_p440      = "Imputation Flag For P440"
         f_p445      = "Imputation Flag For P445"
         f_p450      = "Imputation Flag For P450"
         f_p455      = "Imputation Flag For P455"
         f_p460      = "Imputation Flag For P460"
         f_p465      = "Imputation Flag For P465"
         f_p467      = "Imputation Flag For P467"
         f_p468      = "Imputation Flag For P468"
         f_p470      = "Imputation Flag For P470"
         f_p480      = "Imputation Flag For P480"
         f_p485      = "Imputation Flag For P485"
         f_p490      = "Imputation Flag For P490"
         f_p492      = "Imputation Flag For P492"
         f_p495      = "Imputation Flag For P495"
         f_p500      = "Imputation Flag For P500"
         f_p505      = "Imputation Flag For P505"
         f_p510      = "Imputation Flag For P510"
         f_p515      = "Imputation Flag For P515"
         f_p520      = "Imputation Flag For P520"
         f_p522      = "Imputation Flag For P522"
         f_p525      = "Imputation Flag For P525"
         f_p530      = "Imputation Flag For P530"
         f_p535      = "Imputation Flag For P535"
         f_p540      = "Imputation Flag For P540"
         f_p542      = "Imputation Flag For P542"
         f_p545      = "Imputation Flag For P545"
         f_p550      = "Imputation Flag For P550"
         f_p555      = "Imputation Flag For P555"
         f_p575      = "Imputation Flag For P575"
         f_p580      = "Imputation Flag For P580"
         f_p585      = "Imputation Flag For P585"
         f_p590      = "Imputation Flag For P590"
         f_p600      = "Imputation Flag For P600"
         f_p602      = "Imputation Flag For P602"
         f_p605      = "Imputation Flag For P605"
         f_p610      = "Imputation Flag For P610"
         f_p620      = "Imputation Flag For P620"
         f_p622      = "Imputation Flag For P622"
         f_p625      = "Imputation Flag For P625"
         f_p630      = "Imputation Flag For P630"
         f_p635      = "Imputation Flag For P635"
         f_p640      = "Imputation Flag For P640"
         f_p645      = "Imputation Flag For P645"
         f_p650      = "Imputation Flag For P650"
         f_p655      = "Imputation Flag For P655"
         f_p660      = "Imputation Flag For P660"
         frame       = "Universe frame"
         higr2012    = "2011-12 Highest Grade Level Recode"
         latitude12  = "Latitude"
         level       = "Level of Instruction"
         logr2012    = "2011-12 Lowest Grade Level Recode"
         longitude12 = "Longitude"
         males       = "Number of male students (K-12, UG)"
         numstuds    = "Total number of students in school (K-12, UG)"
         numteach    = "Number of K-12 teachers (FTE)"
         orient      = "School orientation"
         p_asian     = "Percentage of Asian students"
         p_black     = "Percentage of Black students"
         p_hisp      = "Percentage of Hispanic students"
         p_indian    = "Percentage of American Indian or Alaskan Native students"
         p_pacific   = "Percentage of Native Hawaiian or Pacific Islander students"
         p_tr        = "Percentage of students of two or more races"
         p_white     = "Percentage of White students"
         p135        = "5A Ungraded Offered"
         p140        = "5A Ungraded Enrollment"
         p145        = "5B Nursery/Prekindergarten Offered"
         p150        = "5B Nursery/Prekindergarten Enrollment"
         p155        = "5C Kindergarten Offered"
         p160        = "5C Kindergarten Enrollment"
         p165        = "5D Transitional Kindergarten Offered"
         p170        = "5D Transitional Kindergarten Enrollment"
         p175        = "5E Transitional First Grade Offered"
         p180        = "5E Transitional First Grade Enrollment"
         p185        = "5F First Grade Offered"
         p190        = "5F First Grade Enrollment"
         p195        = "5G Second Grade Offered"
         p200        = "5G Second Grade Enrollment"
         p205        = "5H Third Grade Offered"
         p210        = "5H Third Grade Enrollment"
         p215        = "5I Fourth Grade Offered"
         p220        = "5I Fourth Grade Enrollment"
         p225        = "5J Fifth Grade Offered"
         p230        = "5J Fifth Grade Enrollment"
         p235        = "5K Sixth Grade Offered"
         p240        = "5K Sixth Grade Enrollment"
         p245        = "5L Seventh Grade Offered"
         p250        = "5L Seventh Grade Enrollment"
         p255        = "5M Eighth Grade Offered"
         p260        = "5M Eighth Grade Enrollment"
         p265        = "5N Ninth Grade Offered"
         p270        = "5N Ninth Grade Enrollment"
         p275        = "5O Tenth Grade Offered"
         p280        = "5O Tenth Grade Enrollment"
         p285        = "5P Eleventh Grade Offered"
         p290        = "5P Eleventh Grade Enrollment"
         p295        = "5Q Twelfth Grade Offered"
         p300        = "5Q Twelfth Grade Enrollment"
         p305        = "6 Total Student Enrollment"
         p310        = "7F American Indian/Alaska Native Students"
         p316        = "7D Asian Students"
         p318        = "7E Native Hawaiian/Pacific Islander Students"
         p320        = "7A Hispanic Students"
         p325        = "7C Black Students"
         p330        = "7B White Students"
         p332        = "7G Students of two or more races"
         p335        = "8A Is School Coeducational"
         p340        = "8B Male Students"
         p345        = "9A Students in 12th Grade Last Year"
         p350        = "9B Number of 12th Graders Last Year"
         p360        = "9D Percent to 4-Year College"
         p365        = "10A Length of School Day for Kindergarten"
         p370        = "10B Days Per Week for Kindergarten"
         p385        = "11 Full-Time Teachers"
         p390        = "11 3/4 Time Teachers"
         p395        = "11 1/2 Time Teachers"
         p400        = "11 1/4 Time Teachers"
         p405        = "11 Less Than 1/4 Time Teachers"
         p410        = "11 Total Number of Teachers"
         p415        = "12 Type of School"
         p420        = "13A School Supports Home Schooling"
         p425        = "13B Is School Located in Private Home"
         p430        = "14A Does School Have Religious Orientation"
         p435        = "14B School Affiliation"
         p440        = "14C Religious Orientation"
         p445        = "14C Type of Catholic School"
         p450        = "15 No Associations"
         p455        = "15 Accelerated Christian Education"
         p460        = "15 American Association of Christian Schools"
         p465        = "15 Assn of Christian Schools International"
         p467        = "15 Assn of Christian Teachers and Schools"
         p468        = "15 Assn of Classical and Christian Schools"
         p470        = "15 Christian Schools International"
         p480        = "15 Evangelical Lutheran Education Assn"
         p485        = "15 Friends Council on Education"
         p490        = "15 Gen Conference of SDA Church"
         p492        = "15 Islamic School League of America"
         p495        = "15 Jesuit Secondary Education Assn"
         p500        = "15 National Assn of Episcopal Schools"
         p505        = "15 National Catholic Educational Assn"
         p510        = "15 National Christian School Assn"
         p515        = "15 National Society of Hebrew Day Schools"
         p520        = "15 Oral Roberts Univ Educational Fellowship"
         p522        = "15 The Jewish Community Day School Network"
         p525        = "15 Solomon Schechter Day Schools"
         p530        = "15 Southern Baptist Assn of Christian Schools"
         p535        = "15 Other Religious School Associations"
         p540        = "15 American Montessori Society"
         p542        = "15 Association Montessori International"
         p545        = "15 Other Montessori Associations"
         p550        = "15 Assn of Military Colleges and Schools"
         p555        = "15 Assn of Waldorf Schools of North America"
         p575        = "15 Natl Assn of Private Special Education Ctrs"
         p580        = "15 Other Assns for Exceptional Children"
         p585        = "15 European Council for International Schools"
         p590        = "15 National Assn for the Ed of Young Children"
         p600        = "15 National Assn of Laboratory Schools"
         p602        = "15 National Coalition of Girls' Schools"
         p605        = "15 Other Special Emphasis Associations"
         p610        = "15 Alternative School Network"
         p620        = "15 National Association of Independent Schools"
         p622        = "15 State/Regional Independent School Assn"
         p625        = "15 National Coalition of Alt Community Schls"
         p630        = "15 National Independent Private Schools Assn"
         p635        = "15 The Assn of Boarding Schools"
         p640        = "15 Other School Associations"
         p645        = "16 Days in School Year"
         p650        = "17 Hours in School Day for Students"
         p655        = "17 Minutes in School Day for Students"
         p660        = "18 Library"
         p665        = "19 Minutes to Complete Questionnaire"
         paddrs      = "Mailing Address"
         pcity       = "Mailing City"
         pcntnm      = "County Name"
         pcnty       = "ANSI County Code"
         pfnlwt      = "Final Weight"
         pinst       = "School Name"
         pl_add      = "Location Address"
         pl_cit      = "Location City"
         pl_stabb    = "Location State Postal Code"
         pl_zip      = "Location Zip Code"
         pl_zip4     = "Location Zip4 code"
         ppin        = "Permanent Identification Number"
         pstabb      = "Mailing State Postal Code"
         pstansi     = "ANSI State Code"
         pzip        = "Mailing Zip Code"
         pzip4       = "Mailing Zip4 Code"
         region      = "Census Region"
         relig       = "Affiliation"
         repw1       = "Replicate Weight 1"
         repw10      = "Replicate Weight 10"
         repw11      = "Replicate Weight 11"
         repw12      = "Replicate Weight 12"
         repw13      = "Replicate Weight 13"
         repw14      = "Replicate Weight 14"
         repw15      = "Replicate Weight 15"
         repw16      = "Replicate Weight 16"
         repw17      = "Replicate Weight 17"
         repw18      = "Replicate Weight 18"
         repw19      = "Replicate Weight 19"
         repw2       = "Replicate Weight 2"
         repw20      = "Replicate Weight 20"
         repw21      = "Replicate Weight 21"
         repw22      = "Replicate Weight 22"
         repw23      = "Replicate Weight 23"
         repw24      = "Replicate Weight 24"
         repw25      = "Replicate Weight 25"
         repw26      = "Replicate Weight 26"
         repw27      = "Replicate Weight 27"
         repw28      = "Replicate Weight 28"
         repw29      = "Replicate Weight 29"
         repw3       = "Replicate Weight 3"
         repw30      = "Replicate Weight 30"
         repw31      = "Replicate Weight 31"
         repw32      = "Replicate Weight 32"
         repw33      = "Replicate Weight 33"
         repw34      = "Replicate Weight 34"
         repw35      = "Replicate Weight 35"
         repw36      = "Replicate Weight 36"
         repw37      = "Replicate Weight 37"
         repw38      = "Replicate Weight 38"
         repw39      = "Replicate Weight 39"
         repw4       = "Replicate Weight 4"
         repw40      = "Replicate Weight 40"
         repw41      = "Replicate Weight 41"
         repw42      = "Replicate Weight 42"
         repw43      = "Replicate Weight 43"
         repw44      = "Replicate Weight 44"
         repw45      = "Replicate Weight 45"
         repw46      = "Replicate Weight 46"
         repw47      = "Replicate Weight 47"
         repw48      = "Replicate Weight 48"
         repw49      = "Replicate Weight 49"
         repw5       = "Replicate Weight 5"
         repw50      = "Replicate Weight 50"
         repw51      = "Replicate Weight 51"
         repw52      = "Replicate Weight 52"
         repw53      = "Replicate Weight 53"
         repw54      = "Replicate Weight 54"
         repw55      = "Replicate Weight 55"
         repw56      = "Replicate Weight 56"
         repw57      = "Replicate Weight 57"
         repw58      = "Replicate Weight 58"
         repw59      = "Replicate Weight 59"
         repw6       = "Replicate Weight 6"
         repw60      = "Replicate Weight 60"
         repw61      = "Replicate Weight 61"
         repw62      = "Replicate Weight 62"
         repw63      = "Replicate Weight 63"
         repw64      = "Replicate Weight 64"
         repw65      = "Replicate Weight 65"
         repw66      = "Replicate Weight 66"
         repw67      = "Replicate Weight 67"
         repw68      = "Replicate Weight 68"
         repw69      = "Replicate Weight 69"
         repw7       = "Replicate Weight 7"
         repw70      = "Replicate Weight 70"
         repw71      = "Replicate Weight 71"
         repw72      = "Replicate Weight 72"
         repw73      = "Replicate Weight 73"
         repw74      = "Replicate Weight 74"
         repw75      = "Replicate Weight 75"
         repw76      = "Replicate Weight 76"
         repw77      = "Replicate Weight 77"
         repw78      = "Replicate Weight 78"
         repw79      = "Replicate Weight 79"
         repw8       = "Replicate Weight 8"
         repw80      = "Replicate Weight 80"
         repw81      = "Replicate Weight 81"
         repw82      = "Replicate Weight 82"
         repw83      = "Replicate Weight 83"
         repw84      = "Replicate Weight 84"
         repw85      = "Replicate Weight 85"
         repw86      = "Replicate Weight 86"
         repw87      = "Replicate Weight 87"
         repw88      = "Replicate Weight 88"
         repw9       = "Replicate Weight 9"
         s_kg        = "Total number of kindergarten students"
         size        = "Size of school (K-12, UG)"
         sttch_rt    = "Student teacher ratio"
         tabflag     = "Tabulation flag"
         tothrs      = "Length of school day in hours"
         typology    = "School Typology"
         ucommtyp    = "Urban-centric community type"
         ulocale12   = "Urban-centric locale code";
run;

/* Create temporary formats for display of the one-way frequencies */
proc format;
   value tabflagf
            1="Schools offering ungraded or grade 1 or above"
            2="Schools offering no grade higher than KG";

   value $framef
            "LIST"="School is part of list frame"
            "AREA"="School is part of area frame";

   value stfipf
            01="Alabama"
            02="Alaska"
            04="Arizona"
            05="Arkansas"
            06="California"
            08="Colorado"
            09="Connecticut"
            10="Delaware"
            11="District of Columbia"
            12="Florida"
            13="Georgia"
            15="Hawaii"
            16="Idaho"
            17="Illinois"
            18="Indiana"
            19="Iowa"
            20="Kansas"
            21="Kentucky"
            22="Louisiana"
            23="Maine"
            24="Maryland"
            25="Massachusetts"
            26="Michigan"
            27="Minnesota"
            28="Mississippi"
            29="Missouri"
            30="Montana"
            31="Nebraska"
            32="Nevada"
            33="New Hampshire"
            34="New Jersey"
            35="New Mexico"
            36="New York"
            37="North Carolina"
            38="North Dakota"
            39="Ohio"
            40="Oklahoma"
            41="Oregon"
            42="Pennsylvania"
            44="Rhode Island"
            45="South Carolina"
            46="South Dakota"
            47="Tennessee"
            48="Texas"
            49="Utah"
            50="Vermont"
            51="Virginia"
            53="Washington"
            54="West Virginia"
            55="Wisconsin"
            56="Wyoming";

   value $stabbr
            "AL"="AL Alabama"
            "AK"="AK Alaska"
            "AZ"="AZ Arizona"
            "AR"="AR Arkansas"
            "CA"="CA California"
            "CO"="CO Colorado"
            "CT"="CT Connecticut"
            "DE"="DE Delaware"
            "DC"="DC District of Columbia"
            "FL"="FL Florida"
            "GA"="GA Georgia"
            "HI"="HI Hawaii"
            "ID"="ID Idaho"
            "IL"="IL Illinois"
            "IN"="IN Indiana"
            "IA"="IA Iowa"
            "KS"="KS Kansas"
            "KY"="KY Kentucky"
            "LA"="LA Louisiana"
            "ME"="ME Maine"
            "MD"="MD Maryland"
            "MA"="MA Massachusetts"
            "MI"="MI Michigan"
            "MN"="MN Minnesota"
            "MS"="MS Mississippi"
            "MO"="MO Missouri"
            "MT"="MT Montana"
            "NE"="NE Nebraska"
            "NV"="NV Nevada"
            "NH"="NH New Hampshire"
            "NJ"="NJ New Jersey"
            "NM"="NM New Mexico"
            "NY"="NY New York"
            "NC"="NC North Carolina"
            "ND"="ND North Dakota"
            "OH"="OH Ohio"
            "OK"="OK Oklahoma"
            "OR"="OR Oregon"
            "PA"="PA Pennsylvania"
            "RI"="RI Rhode Island"
            "SC"="SC South Carolina"
            "SD"="SD South Dakota"
            "TN"="TN Tennessee"
            "TX"="TX Texas"
            "UT"="UT Utah"
            "VT"="VT Vermont"
            "VA"="VA Virginia"
            "WA"="WA Washington"
            "WV"="WV West Virginia"
            "WI"="WI Wisconsin"
            "WY"="WY Wyoming";

   value yesnof
            1="Yes"
            2="No";

   value assnf
            0="Not member"
            1="Member";

   value p450f
            0="Does belong to an organization/association"
            1="Does not belong to an organization/association";

   value csourcef
            .="Valid Skip"
            1="Mail"
            2="Internet"
            3="Regional Office follow-up"
            4="CATI (computer-assisted telephone interview)";

   value p335f
            1="Yes"
            2="No, it is an all-female school"
            3="No, it is an all-male school";

   value p365f
            0="N/A"
            1="Full day"
            2="Half day"
            3="Both offered";

   value p415f
            1="Regular elementary or secondary"
            2="Montessori"
            3="Special program emphasis"
            4="Special education"
            5="Career/technical/vocational"
            6="Alternative/other"
            7="Early childhood program/child care center";

   value p440f
            01="Roman Catholic"
            02="African Methodist Episcopal"
            03="Amish"
            04="Assembly of God"
            05="Baptist"
            06="Brethren"
            07="Calvinist"
            08="Christian (no specific denomination)"
            09="Church of Christ"
            10="Church of God"
            11="Church of God in Christ"
            12="Church of the Nazarene"
            13="Disciples of Christ"
            14="Episcopal"
            15="Friends"
            16="Greek Orthodox"
            17="Islamic"
            18="Jewish"
            19="Latter Day Saints"
            20="Lutheran Church - Missouri Synod"
            21="Evangelical Lutheran Church in America"
            22="Wisconsin Evangelical Lutheran Synod"
            23="Other Lutheran"
            24="Mennonite"
            25="Methodist"
            26="Pentecostal"
            27="Presbyterian"
            28="Seventh-Day Adventist"
            29="Other";

   value p445f
            1="Parochial"
            2="Diocesan"
            3="Private";

   value regionf
            1="Northeast"
            2="Midwest"
            3="South"
            4="West";

   value ulocalef
            11="City, Large"
            12="City, Midsize"
            13="City, Small"
            21="Suburb, Large"
            22="Suburb, Midsize"
            23="Suburb, Small"
            31="Town, Fringe"
            32="Town, Distant"
            33="Town, Remote"
            41="Rural, Fringe"
            42="Rural, Distant"
            43="Rural, Remote";

   value ucommtypf
            1="City (ulocale=11, 12, 13)"
            2="Suburb (ulocale=21, 22, 23)"
            3="Town (ulocale=31, 32, 33)"
            4="Rural (ulocale=41, 42, 43)";

   value logrf
            01="All Ungraded"
            02="Lowest grade in school is PK"
            03="Lowest grade in school is KG"
            04="Lowest grade in school is transitional KG"
            05="Lowest grade in school is transitional 1st grade"
            06="Lowest grade in school is 1st grade"
            07="Lowest grade in school is 2nd grade"
            08="Lowest grade in school is 3rd grade"
            09="Lowest grade in school is 4th grade"
            10="Lowest grade in school is 5th grade"
            11="Lowest grade in school is 6th grade"
            12="Lowest grade in school is 7th grade"
            13="Lowest grade in school is 8th grade"
            14="Lowest grade in school is 9th grade"
            15="Lowest grade in school is 10th grade"
            16="Lowest grade in school is 11th grade"
            17="Lowest grade in school is 12th grade";

   value higrf
            01="All Ungraded"
            02="Highest grade in school is PK"
            03="Highest grade in school is KG"
            04="Highest grade in school is transitional KG"
            05="Highest grade in school is trans. 1st grade"
            06="Highest grade in school is 1st grade"
            07="Highest grade in school is 2nd grade"
            08="Highest grade in school is 3rd grade"
            09="Highest grade in school is 4th grade"
            10="Highest grade in school is 5th grade"
            11="Highest grade in school is 6th grade"
            12="Highest grade in school is 7th grade"
            13="Highest grade in school is 8th grade"
            14="Highest grade in school is 9th grade"
            15="Highest grade in school is 10th grade"
            16="Highest grade in school is 11th grade"
            17="Highest grade in school is 12th grade";

   value typologyf
            1="Catholic, parochial"
            2="Catholic, diocesan"
            3="Catholic, private"
            4="Other religious, conservative Christian"
            5="Other relig., affiliated w/ established denomination"
            6="Other relig., not affiliated w/ any denomination"
            7="Nonsectarian, regular school"
            8="Nonsectarian, special program"
            9="Nonsectarian, special education";

   value religf
            1="Catholic (p430=1 and p440=1)"
            2="Other religious (p430=1 and p440 ne 1)"
            3="Nonsectarian (p430=2)";

   value levelf
            1="Elementary"
            2="Secondary"
            3="Combined elementary and secondary";

   value sizef
            1="Less than 50 students"
            2="50-149 students"
            3="150-299 students"
            4="300-499 students"
            5="500-749 students"
            6="750 students or more";

   value impflagf
            0="Not imputed  (original data)"
            1="Ratio adjustment of original data"
            2="Imputed by using data from other variables"
            3="Imputed by using a donor value"
            4="Clerical imputation"
            5="Data adjusted by analyst during review";

   value orientf
            01="Roman Catholic"
            02="African Methodist Episcopal"
            03="Amish"
            04="Assembly of God"
            05="Baptist"
            06="Brethren"
            07="Calvinist"
            08="Christian (no specific denomination)"
            09="Church of Christ"
            10="Church of God"
            11="Church of God in Christ"
            12="Church of the Nazarene"
            13="Disciples of Christ"
            14="Episcopal"
            15="Friends"
            16="Greek Orthodox"
            17="Islamic"
            18="Jewish"
            19="Latter Day Saints"
            20="Lutheran Church - Missouri Synod"
            21="Evangelical Lutheran Church in America"
            22="Wisconsin Evangelical Lutheran Synod"
            23="Other Lutheran"
            24="Mennonite"
            25="Methodist"
            26="Pentecostal"
            27="Presbyterian"
            28="Seventh-Day Adventist"
            29="Other"
            30="Nonsectarian";

   value diocesef
            0101="Diocese of Birmingham, AL"
            0102="Diocese of Mobile, AL"
            0201="Archdiocese of Anchorage, AK"
            0202="Diocese of Fairbanks, AK"
            0203="Diocese of Juneau, AK"
            0401="Diocese of Phoenix, AZ"
            0402="Diocese of Tucson, AZ"
            0501="Diocese of Little Rock, AR"
            0601="Archdiocese of Los Angeles, CA"
            0602="Archdiocese of San Francisco, CA"
            0603="Diocese of Fresno, CA"
            0604="Diocese of Monterey, CA"
            0605="Diocese of Oakland, CA"
            0606="Diocese of Orange, CA"
            0607="Diocese of Sacramento, CA"
            0608="Diocese of San Bernardino, CA"
            0609="Diocese of San Diego, CA"
            0610="Diocese of San Jose, CA"
            0611="Diocese of Santa Rosa, CA"
            0612="Diocese of Stockton, CA"
            0801="Archdiocese of Denver, CO"
            0802="Diocese of Colorado Springs, CO"
            0803="Diocese of Pueblo, CO"
            0901="Archdiocese of Hartford, CT"
            0902="Diocese of Bridgeport, CT"
            0903="Diocese of Norwich, CT"
            1001="Diocese of Wilmington, DE"
            1101="Archdiocese of Washington, DC"
            1201="Archdiocese of Miami, FL"
            1202="Diocese of Pensacola-Tallahassee, FL"
            1203="Diocese of Orlando, FL"
            1204="Diocese of Palm Beach, FL"
            1205="Diocese of St. Augustine, FL"
            1206="Diocese of St. Petersburg, FL"
            1207="Diocese of Venice, FL"
            1301="Archdiocese of Atlanta, GA"
            1302="Diocese of Savannah, GA"
            1501="Diocese of Honolulu, HI"
            1601="Diocese of Boise, ID"
            1701="Archdiocese of Chicago, IL"
            1702="Diocese of Belleville, IL"
            1703="Diocese of Joliet, IL"
            1704="Diocese of Peoria, IL"
            1705="Diocese of Rockford, IL"
            1706="Diocese of Springfield, IL"
            1801="Archdiocese of Indianapolis, IN"
            1802="Diocese of Evansville, IN"
            1803="Diocese of Ft. Wayne-South Bend, IN"
            1804="Diocese of Gary, IN"
            1805="Diocese of Lafayette, IN"
            1901="Archdiocese of Dubuque, IA"
            1902="Diocese of Davenport, IA"
            1903="Diocese of Des Moines, IA"
            1904="Diocese of Sioux City, IA"
            2001="Archdiocese of Kansas City, KS"
            2002="Diocese of Dodge City, KS"
            2003="Diocese of Salina, KS"
            2004="Diocese of Wichita, KS"
            2101="Archdiocese of Louisville, KY"
            2102="Diocese of Covington, KY"
            2103="Diocese of Lexington, KY"
            2104="Diocese of Owensboro, KY"
            2201="Archdiocese of New Orleans, LA"
            2202="Diocese of Alexandria, LA"
            2203="Diocese of Baton Rouge, LA"
            2204="Diocese of Houma-Thibodaux, LA"
            2205="Diocese of Lafayette, LA"
            2206="Diocese of Lake Charles, LA"
            2207="Diocese of Shreveport, LA"
            2301="Diocese of Portland, ME"
            2401="Archdiocese of Baltimore, MD"
            2501="Archdiocese of Boston, MA"
            2502="Diocese of Fall River, MA"
            2503="Diocese of Springfield, MA"
            2504="Diocese of Worcester, MA"
            2601="Archdiocese of Detroit, MI"
            2602="Diocese of Grand Rapids, MI"
            2603="Diocese of Gaylord, MI"
            2604="Diocese of Kalamazoo, MI"
            2605="Diocese of Lansing, MI"
            2606="Diocese of Marquette, MI"
            2607="Diocese of Saginaw, MI"
            2701="Archdiocese of St. Paul-Minneapolis, MN"
            2702="Diocese of Crookston, MN"
            2703="Diocese of Duluth, MN"
            2704="Diocese of New Ulm, MN"
            2705="Diocese of St. Cloud, MN"
            2706="Diocese of Winona, MN"
            2801="Diocese of Biloxi, MS"
            2802="Diocese of Jackson, MS"
            2901="Archdiocese of St. Louis, MO"
            2902="Diocese of Jefferson City, MO"
            2903="Diocese of Kansas City-St. Joseph, MO"
            2904="Diocese of Springfield-Cape Girardeau, MO"
            3001="Diocese of Great Falls-Billings, MT"
            3002="Diocese of Helena, MT"
            3101="Archdiocese of Omaha, NE"
            3102="Diocese of Grand Island, NE"
            3103="Diocese of Lincoln, NE"
            3201="Diocese of Las Vegas, NV"
            3202="Diocese of Reno, NV"
            3301="Diocese of Manchester, NH"
            3401="Archdiocese of Newark, NJ"
            3402="Diocese of Camden, NJ"
            3403="Diocese of Metuchen, NJ"
            3404="Diocese of Paterson, NJ"
            3405="Diocese of Trenton, NJ"
            3501="Archdiocese of Santa Fe, NM"
            3502="Diocese of Gallup, NM"
            3503="Diocese of Las Cruces, NM"
            3601="Archdiocese of New York, NY"
            3602="Diocese of Albany, NY"
            3603="Diocese of Brooklyn, NY"
            3604="Diocese of Buffalo, NY"
            3605="Diocese of Ogdensburg, NY"
            3606="Diocese of Rochester, NY"
            3607="Diocese of Rockville Centre, NY"
            3608="Diocese of Syracuse, NY"
            3701="Diocese of Charlotte, NC"
            3702="Diocese of Raleigh, NC"
            3801="Diocese of Bismarck, ND"
            3802="Diocese of Fargo, ND"
            3901="Archdiocese of Cincinnati, OH"
            3902="Diocese of Cleveland, OH"
            3903="Diocese of Columbus, OH"
            3904="Diocese of Steubenville, OH"
            3905="Diocese of Toledo, OH"
            3906="Diocese of Youngstown, OH"
            4001="Archdiocese of Oklahoma City, OK"
            4002="Diocese of Tulsa, OK"
            4101="Archdiocese of Portland, OR"
            4102="Diocese of Baker, OR"
            4201="Archdiocese of Philadelphia, PA"
            4202="Diocese of Allentown, PA"
            4203="Diocese of Altoona-Johnstown, PA"
            4204="Diocese of Erie, PA"
            4205="Diocese of Greensburg, PA"
            4206="Diocese of Harrisburg, PA"
            4207="Diocese of Pittsburgh, PA"
            4208="Diocese of Scranton, PA"
            4401="Diocese of Providence, RI"
            4501="Diocese of Charleston, SC"
            4601="Diocese of Rapid City, SD"
            4602="Diocese of Sioux Falls, SD"
            4701="Diocese of Knoxville, TN"
            4702="Diocese of Memphis, TN"
            4703="Diocese of Nashville, TN"
            4801="Archdiocese of San Antonio, TX"
            4802="Diocese of Amarillo, TX"
            4803="Diocese of Austin, TX"
            4804="Diocese of Beaumont, TX"
            4805="Diocese of Brownsville, TX"
            4806="Diocese of Corpus Christi, TX"
            4807="Diocese of Dallas, TX"
            4808="Diocese of El Paso, TX"
            4809="Diocese of Ft. Worth, TX"
            4810="Diocese of Galveston-Houston, TX"
            4811="Diocese of Lubbock, TX"
            4812="Diocese of San Angelo, TX"
            4813="Diocese of Tyler, TX"
            4814="Diocese of Victoria, TX"
            4815="Diocese of Laredo, TX"
            4901="Diocese of Salt Lake, UT"
            5001="Diocese of Burlington, VT"
            5101="Diocese of Arlington, VA"
            5102="Diocese of Richmond, VA"
            5301="Archdiocese of Seattle, WA"
            5302="Diocese of Spokane, WA"
            5303="Diocese of Yakima, WA"
            5401="Diocese of Wheeling-Charleston, WV"
            5501="Archdiocese of Milwaukee, WI"
            5502="Diocese of Green Bay, WI"
            5503="Diocese of La Crosse, WI"
            5504="Diocese of Madison, WI"
            5505="Diocese of Superior, WI"
            5601="Diocese of Cheyenne, WY";
run;

 *******************************************************************
 *** The following lines of code have been commented out. If you ***
 *** wish to run frequencies, or display file contents you can   ***
 *** submit the following procedures separately or remove the    ***
 *** "/*" and "*/" characters to run both procedures. You may    ***
 *** also comment out the final school weight when running the   ***
 *** frequencies.                                                ***
 *******************************************************************;

/*
*** One-way frequencies of categorical variables ***;
proc freq data=pss1112_pu;
   table p135  p145  p155  p165  p175  p185  p195  p205  p215  p225  p235  p245
         p255  p265  p275  p285  p295  p335  p345  p365  p370  p415  p420  p425
         p430  p435  p440  p445  p450  p455  p460  p465  p467  p468  p470  p480
         p485  p490  p492  p495  p500  p505  p510  p515  p520  p522  p525  p530
         p535  p540  p542  p545  p550  p555  p575  p580  p585  p590  p600  p602
         p605  p610  p620  p622  p625  p630  p635  p640  p655  p660
         csource region pstansi pstabb ulocale12 logr2012 higr2012 frame
         tabflag typology relig orient diocese level size ucommtyp
         f_p135  f_p140  f_p145  f_p150  f_p155  f_p160  f_p165  f_p170  f_p175
         f_p180  f_p185  f_p190  f_p195  f_p200  f_p205  f_p210  f_p215  f_p220
         f_p225  f_p230  f_p235  f_p240  f_p245  f_p250  f_p255  f_p260  f_p265
         f_p270  f_p275  f_p280  f_p285  f_p290  f_p295  f_p300  f_p305  f_p310
         f_p316  f_p318  f_p320  f_p325  f_p330  f_p332  f_p335  f_p340  f_p345
         f_p350  f_p360  f_p365  f_p370  f_p385  f_p390  f_p395  f_p400  f_p405
         f_p410  f_p415  f_p420  f_p425  f_p430  f_p435  f_p440  f_p445  f_p450
         f_p455  f_p460  f_p465  f_p467  f_p468  f_p470  f_p480  f_p485  f_p490
         f_p492  f_p495  f_p500  f_p505  f_p510  f_p515  f_p520  f_p522  f_p525
         f_p530  f_p535  f_p540  f_p542  f_p545  f_p550  f_p555  f_p575  f_p580
         f_p585  f_p590  f_p600  f_p602  f_p605  f_p610  f_p620  f_p622  f_p625
         f_p630  f_p635  f_p640  f_p645  f_p650  f_p655  f_p660  / missing;

   format p135  p145  p155  p165  p175  p185  p195  p205  p215  p225  p235  p245
          p255  p265  p275  p285  p295  p345  p420  p425  p430  p435  p660 yesnof.
          p455  p460  p465  p467  p468  p470  p480  p485  p490  p492  p495  p500
          p505  p510  p515  p520  p522  p525  p530  p535  p540  p542  p545  p550
          p555  p575  p580  p585  p590  p600  p602  p605  p610  p620  p622  p625
          p630  p635  p640  assnf.
          p335 p335f. p365 p365f. p415 p415f. p440 p440f. p445 p445f. p450 p450f.
          csource csourcef. region regionf. pstansi stfipf. pstabb $stabbr.
          ulocale12 ulocalef. logr2012 logrf. higr2012 higrf. frame $framef.
          tabflag tabflagf. typology typologyf. relig religf. orient orientf.
          diocese diocesef. level levelf. size sizef. ucommtyp ucommtypf.
          f_p135  f_p140  f_p145  f_p150  f_p155  f_p160  f_p165  f_p170  f_p175
          f_p180  f_p185  f_p190  f_p195  f_p200  f_p205  f_p210  f_p215  f_p220
          f_p225  f_p230  f_p235  f_p240  f_p245  f_p250  f_p255  f_p260  f_p265
          f_p270  f_p275  f_p280  f_p285  f_p290  f_p295  f_p300  f_p305  f_p310
          f_p316  f_p318  f_p320  f_p325  f_p330  f_p332  f_p335  f_p340  f_p345
          f_p350  f_p360  f_p365  f_p370  f_p385  f_p390  f_p395  f_p400  f_p405
          f_p410  f_p415  f_p420  f_p425  f_p430  f_p435  f_p440  f_p445  f_p450
          f_p455  f_p460  f_p465  f_p467  f_p468  f_p470  f_p480  f_p485  f_p490
          f_p492  f_p495  f_p500  f_p505  f_p510  f_p515  f_p520  f_p522  f_p525
          f_p530  f_p535  f_p540  f_p542  f_p545  f_p550  f_p555  f_p575  f_p580
          f_p585  f_p590  f_p600  f_p602  f_p605  f_p610  f_p620  f_p622  f_p625
          f_p630  f_p635  f_p640  f_p645  f_p650  f_p655  f_p660  impflagf.;

   weight pfnlwt;

   title 'Frequencies of Categorical Variables: PSS 2011-2012';
run;

*** Data file contents ***;
proc contents data=pss1112_pu varnum;
   title 'Private School Survey, 2011-2012';
run;
*/