**************************************************************************************************.
***   Created: June 30, 2006  			                                               		***.
***   Modify the FILE = path below to point to your data file                                  		***.
***   Written by: Kforce Government Solutions                                                                  ***.
***                                                                                            			 	***.
***   Program Name: Read_PSS9596_PU.sps                                                      	***.
***   Data file Name:  PSS9596_PU.txt                                                             		***.
***   The tab delimited file which is specified in the program must                            	***.
***   be saved in the directory specified by SAVE OUTFILE statement                            	***.
***                                                                                            				***.
***   SPSS code was written for SPSS version 11.5 or above.  Value Labels were                ***.
***   given a maximum length of 60 characters.  If any of the value labels are truncated       	***.
***   due to the version of SPSS, the user may wish to abbreviate labels so that               	***.
***   they are unique and descriptive.                                                         		***.
***                                                                                            				***. 
***.
**************************************************************************************************.

**************************************************************************************************.
***    Change directory path FILE= to point to where PSS9596_PU.TXT is stored                     ***.

GET DATA  /TYPE = TXT
 /FILE =
  'C:\PUBLIC USE\PSS_DATA\PSS9596_PU.txt'
 /DELCASE = LINE
 /DELIMITERS = "\t"
 /ARRANGEMENT = DELIMITED
 /FIRSTCASE = 2
 /IMPORTCASE = ALL
/VARIABLES =
 QPIN A8
 QCITY A14
 QSTABB A2
 QSTFIP F8
 QCNTY A3
 QCNTNM A14
 STCNTY A15
 QZIP A10
 SCHOOL F8
 P135 F8
 P140 F8
 P145 F8
 P150 F8
 P155 F8
 P160 F8
 P165 F8
 P170 F8
 P175 F8
 P180 F8
 S_KG F8
 P185 F8
 P190 F8
 P195 F8
 P200 F8
 P205 F8
 P210 F8
 P215 F8
 P220 F8
 P225 F8
 P230 F8
 P235 F8
 P240 F8
 P245 F8
 P250 F8
 P255 F8
 P260 F8
 P265 F8
 P270 F8
 P275 F8
 P280 F8
 P285 F8
 P290 F8
 P295 F8
 P300 F8
 P305 F8
 P310 F8
 P315 F8
 P320 F8
 P325 F8
 P330 F8 
 P340 F8
 P345 F8
 P350 F8
 P355 F8
 P360 F8
 P365 F8
 P370 F8
 P375 F8
 P380 F8
 P385 F8
 P390 F8
 P395 F8
 P400 F8
 P405 F8
 P410 F8
 P415 F8
 P420 F8
 P425 F8
 P430 F8
 P435 F8
 P440 F8
 P445 F8
 P450 F8
 P455 F8
 P460 F8
 P465 F8
 P470 F8
 P475 F8
 P480 F8
 P485 F8
 P490 F8
 P495 F8
 P500 F8
 P505 F8
 P510 F8
 P515 F8
 P520 F8
 P525 F8
 P530 F8
 P535 F8
 P540 F8
 P545 F8
 P550 F8
 P555 F8
 P560 F8
 P565 F8
 P570 F8
 P575 F8
 P580 F8
 P585 F8
 P590 F8
 P595 F8
 P600 F8
 P605 F8
 P610 F8
 P615 F8
 P620 F8
 P625 F8
 P630 F8
 P635 F8
 P640 F8
 P645 F8
 P650 F8
 COMMTYPE F8
 FRAME A4
 HOURS F8
 LEVEL F8
 LOCALE A1
 MINOR F8
 NUMSTUDS F8
 NUMTEACH F8
 ORIENT F8
 P_INDIAN F12.2
 P_ASIAN F12.2
 P_HISP F12.2
 P_BLACK F12.2
 P_WHITE F12.2
 PERMINOR F12.2
 QHIGR6 F8
 QLOGR6 F8
 REGION F8
 RELIG F8
 SIZE F8
 STTCH_RT F12.2
 TABFLAG1 F12.2
 TABFLAG2 F12.2
 TYPOLOGY F8
 QFNLWT F12.2
 REPW1 F12.2
 REPW2 F12.2
 REPW3 F12.2
 REPW4 F12.2
 REPW5 F12.2
 REPW6 F12.2
 REPW7 F12.2
 REPW8 F12.2
 REPW9 F12.2
 REPW10 F12.2
 REPW11 F12.2
 REPW12 F12.2
 REPW13 F12.2
 REPW14 F12.2
 REPW15 F12.2
 REPW16 F12.2
 REPW17 F12.2
 REPW18 F12.2
 REPW19 F12.2
 REPW20 F12.2
 REPW21 F12.2
 REPW22 F12.2
 REPW23 F12.2
 REPW24 F12.2
 REPW25 F12.2
 REPW26 F12.2
 REPW27 F12.2
 REPW28 F12.2
 REPW29 F12.2
 REPW30 F12.2
 REPW31 F12.2
 REPW32 F12.2
 REPW33 F12.2
 REPW34 F12.2
 REPW35 F12.2
 REPW36 F12.2
 REPW37 F12.2
 REPW38 F12.2
 REPW39 F12.2
 REPW40 F12.2
 REPW41 F12.2
 REPW42 F12.2
 REPW43 F12.2
 REPW44 F12.2
 REPW45 F12.2
 REPW46 F12.2
 REPW47 F12.2
 REPW48 F12.2
 F_P135 F8
 F_P140 F8
 F_P145 F8
 F_P150 F8
 F_P155 F8
 F_P160 F8
 F_P165 F8
 F_P170 F8
 F_P175 F8
 F_P180 F8
 F_P185 F8
 F_P190 F8
 F_P195 F8
 F_P200 F8
 F_P205 F8
 F_P210 F8
 F_P215 F8
 F_P220 F8
 F_P225 F8
 F_P230 F8
 F_P235 F8
 F_P240 F8
 F_P245 F8
 F_P250 F8
 F_P255 F8
 F_P260 F8
 F_P265 F8
 F_P270 F8
 F_P275 F8
 F_P280 F8
 F_P285 F8
 F_P290 F8
 F_P295 F8
 F_P300 F8
 F_P305 F8
 F_P310 F8
 F_P315 F8
 F_P320 F8
 F_P325 F8
 F_P330 F8
 F_P340 F8
 F_P345 F8
 F_P350 F8
 F_P355 F8
 F_P360 F8
 F_P365 F8
 F_P370 F8
 F_P375 F8
 F_P380 F8
 F_P385 F8
 F_P390 F8
 F_P395 F8
 F_P400 F8
 F_P405 F8
 F_P410 F8
 F_P415 F8
 F_P420 F8
 F_P425 F8
 F_P430 F8
 F_P435 F8
 F_P440 F8
 F_P445 F8
 F_P450 F8
 F_P455 F8
 F_P460 F8
 F_P465 F8
 F_P470 F8
 F_P475 F8
 F_P480 F8
 F_P485 F8
 F_P490 F8
 F_P495 F8
 F_P500 F8
 F_P505 F8
 F_P510 F8
 F_P515 F8
 F_P520 F8
 F_P525 F8
 F_P530 F8
 F_P535 F8
 F_P540 F8
 F_P545 F8
 F_P550 F8
 F_P555 F8
 F_P560 F8
 F_P565 F8
 F_P570 F8
 F_P575 F8
 F_P580 F8
 F_P585 F8
 F_P590 F8
 F_P595 F8
 F_P600 F8
 F_P605 F8
 F_P610 F8
 F_P615 F8
 F_P620 F8
 F_P625 F8
 F_P630 F8
 F_P635 F8
 F_P640 F8
 F_P645 F8
 .
variable Labels
QPIN		 'Permanent Identification Number'
QCITY		 'City of Mailing Address'
QSTABB		 'State Postal Code of Mailing Address'
QSTFIP		 'Fips State Code'
QCNTY		 'Fips County Code'
QCNTNM		 'County Name'
STCNTY		 'Fips State/County Code'
QZIP		 'Zip Code of Mailing Address (Zip + 4)'
SCHOOL		 'School Counter'
P135		 '5A Ungraded Offered'
P140		 '5A Ungraded Enrollment'
P145		 '5B Nursery/Prekindergarten Offered'
P150		 '5B Nursery/Prekindergarten Enrollment'
P155		 '5C Transitional Kindergarten Offered'
P160		 '5C Transitional Kindergarten Enrollment'
P165		 '5D Kindergarten Offered'
P170		 '5D Kindergarten Enrollment'
P175		 '5E Transitional First Grade Offered'
P180		 '5E Transitional First Grade Enrollment'
S_KG		 'Total Kindergarten Enrollment'
P185		 '5F First Grade Offered'
P190		 '5F First Grade Enrollment'
P195		 '5G Second Grade Offered'
P200		 '5G Second Grade Enrollment'
P205		 '5H Third Grade Offered'
P210		 '5H Third Grade Enrollment'
P215		 '5I Fourth Grade Offered'
P220		 '5I Fourth Grade Enrollment'
P225		 '5J Fifth Grade Offered'
P230		 '5J Fifth Grade Enrollment'
P235		 '5K Sixth Grade Offered'
P240		 '5K Sixth Grade Enrollment'
P245		 '5L Seventh Grade Offered'
P250		 '5L Seventh Grade Enrollment'
P255		 '5M Eighth Grade Offered'
P260		 '5M Eighth Grade Enrollment'
P265		 '5N Ninth Grade Offered'
P270		 '5N Ninth Grade Enrollment'
P275		 '5O Tenth Grade Offered'
P280		 '5O Tenth Grade Enrollment'
P285		 '5P Eleventh Grade Offered'
P290		 '5P Eleventh Grade Enrollment'
P295		 '5Q Twelfth Grade Offered'
P300		 '5Q Twelfth Grade Enrollment'
P305		 '6 Total Student Enrollment'
P310		 '7A Kindergarten,Trans Kind or Trans Firs'
P315		 '7B Half Day or Full Day'
P320		 '7C Days Per Week'
P325		 '8A Students in 12th Grade Last Year'
P330		 '8B How Many in 12th Grade Last Year'
P340		 '8D How Many Applied To College'
P345		 '9A Am Indian/Alaska Native Students'
P350		 '9B Asian or Pacific Islander Students'
P355		 '9C Hispanic Students'
P360		 '9D Black Students'
P365		 '9E White Students'
P370		 '10 Days in School Year for Students'
P375		 '11 Hours in School Day for Students'
P380		 '11 Minutes in School Day for Students'
P385		 '12 Full-Time Teachers'
P390		 '12 More than 3/4 Time Teachers'
P395		 '12 More than 1/2 Time Teachers'
P400		 '12 More than 1/4 Time Teachers'
P405		 '12 Less than 1/4 Time Teachers'
P410		 '12 Total Number of Teachers'
P415		 '13A Type of School'
P420		 '13B School Support Home Schooling'
P425		 '14 Is School Located in Private Home'
P430		 '15A Does School Have Relig. Orientation'
P435		 '15B Sch formally Affiliated w/Religious'
P440		 '15C Schools Religious Orientation/Affil.'
P445		 '15D What Type of Catholic School'
P450		 '16 Accelerated Christian Education'
P455		 '16 Alternative School Network'
P460		 '16 Natl Coalition of Alt Community Sch'
P465		 '16 American Assn of Christian Schools'
P470		 '16 American Montessori Society'
P475		 '16 Other Montessori Associations'
P480		 '16 Assn of Christian Schools Internatl'
P485		 '16 Assn of Military Colleges and Schools'
P490		 '16 Bilingual School Association'
P495		 '16 Council of Bilingual Education'
P500		 '16 Other Assns for Bilingual Education'
P505		 '16 Christian Schools International'
P510		 '16 Council for Exceptional Children'
P515		 '16 Natl Assn of Private Schls/Ex Childre'
P520		 '16 Other Assns for Exceptional Children'
P525		 '16 Council of Islamic Schls in N. Americ'
P530		 '16 Natl Assn for the Ed of Young Childre'
P535		 '16 Other Early Childhood Education Assns'
P540		 '16 European Council for Internatl School'
P545		 '16 Other Assns for International Schools'
P550		 '16 Friends Council on Education'
P555		 '16 Gen Conference of 7th-Day Adventist C'
P560		 '16 National Assn of Episcopal Schools'
P565		 '16 National Assn of Independent Schools'
P570		 '16 Natl Independent Private School Assn'
P575		 '16 Other Independent School Associations'
P580		 '16 National Assn of Laboratory Schools'
P585		 '16 National Catholic Educational Assn'
P590		 '16 Jesuit Secondary Education Assn'
P595		 '16 Natl Center for Neighborhood Enterpri'
P600		 '16 National Federation of Church Schools'
P605		 '16 National Society of Hebrew Day School'
P610		 '16 Solomon Schechter Day Schools'
P615		 '16 Other Jewish School Associations'
P620		 '16 Oral Roberts Univ Educational Fellows'
P625		 '16 Other Christian School Associations'
P630		 '16 Other Religious School Associations'
P635		 '16 Other Nonreligious School Association'
P640		 '16 None of the Above Associations'
P645		 '17 What Year Was School Founded'
P650		 '18 Minutes To Complete Questionnaire'
COMMTYPE	 'Community Type'
FRAME		 'Universe Frame To Which School Belongs'
HOURS		 'Length of School Day in Hours'
LEVEL		 'Level of Instruction'
LOCALE		 'New Urbanicity Defined (Census Assigned)'
MINOR		 'Total Minority Students'
NUMSTUDS	 'Total No. of Students in Schl (K-12, Ug)'
NUMTEACH	 'Total No. of Full-Time Equiv. Tchrs Ftes'
ORIENT		 'School Orientation'
P_INDIAN	 'Percent Am Indian/Alaskan Native Stdts'
P_ASIAN		 'Percent Asian or Pacific Islander Stdts'
P_HISP		 'Percent Hispanic Students'
P_BLACK		 'Percent Black Students'
P_WHITE		 'Percent White Students'
PERMINOR	 'Percent Minority Students (Recode)'
QHIGR6		 '1996 Highest Grade Level Recode'
QLOGR6		 '1996 Lowest Grade Level Recode'
REGION		 'Census Region'
RELIG		 'School Affiliation'
SIZE		 'Size of School (Enrollment Recode)'
STTCH_RT	 'Student/Teacher Ratio'
TABFLAG1	 'Schl offrs Grades Ug, 1 + - Traditional'
TABFLAG2	 'Schl offrs Grades K or Lower - All Pss'
TYPOLOGY	 'School Typology'
QFNLWT		 'Final Weight for School'
REPW1		 'Replicate Weight 1'
REPW2		 'Replicate Weight 2'
REPW3		 'Replicate Weight 3'
REPW4		 'Replicate Weight 4'
REPW5		 'Replicate Weight 5'
REPW6		 'Replicate Weight 6'
REPW7		 'Replicate Weight 7'
REPW8		 'Replicate Weight 8'
REPW9		 'Replicate Weight 9'
REPW10		 'Replicate Weight 10'
REPW11		 'Replicate Weight 11'
REPW12		 'Replicate Weight 12'
REPW13		 'Replicate Weight 13'
REPW14		 'Replicate Weight 14'
REPW15		 'Replicate Weight 15'
REPW16		 'Replicate Weight 16'
REPW17		 'Replicate Weight 17'
REPW18		 'Replicate Weight 18'
REPW19		 'Replicate Weight 19'
REPW20		 'Replicate Weight 20'
REPW21		 'Replicate Weight 21'
REPW22		 'Replicate Weight 22'
REPW23		 'Replicate Weight 23'
REPW24		 'Replicate Weight 24'
REPW25		 'Replicate Weight 25'
REPW26		 'Replicate Weight 26'
REPW27		 'Replicate Weight 27'
REPW28		 'Replicate Weight 28'
REPW29		 'Replicate Weight 29'
REPW30		 'Replicate Weight 30'
REPW31		 'Replicate Weight 31'
REPW32		 'Replicate Weight 32'
REPW33		 'Replicate Weight 33'
REPW34		 'Replicate Weight 34'
REPW35		 'Replicate Weight 35'
REPW36		 'Replicate Weight 36'
REPW37		 'Replicate Weight 37'
REPW38		 'Replicate Weight 38'
REPW39		 'Replicate Weight 39'
REPW40		 'Replicate Weight 40'
REPW41		 'Replicate Weight 41'
REPW42		 'Replicate Weight 42'
REPW43		 'Replicate Weight 43'
REPW44		 'Replicate Weight 44'
REPW45		 'Replicate Weight 45'
REPW46		 'Replicate Weight 46'
REPW47		 'Replicate Weight 47'
REPW48		 'Replicate Weight 48'
F_P135		 'Imputation Flag for P135'
F_P140		 'Imputation Flag for P140'
F_P145		 'Imputation Flag for P145'
F_P150		 'Imputation Flag for P150'
F_P155		 'Imputation Flag for P155'
F_P160		 'Imputation Flag for P160'
F_P165		 'Imputation Flag for P165'
F_P170		 'Imputation Flag for P170'
F_P175		 'Imputation Flag for P175'
F_P180		 'Imputation Flag for P180'
F_P185		 'Imputation Flag for P185'
F_P190		 'Imputation Flag for P190'
F_P195		 'Imputation Flag for P195'
F_P200		 'Imputation Flag for P200'
F_P205		 'Imputation Flag for P205'
F_P210		 'Imputation Flag for P210'
F_P215		 'Imputation Flag for P215'
F_P220		 'Imputation Flag for P220'
F_P225		 'Imputation Flag for P225'
F_P230		 'Imputation Flag for P230'
F_P235		 'Imputation Flag for P235'
F_P240		 'Imputation Flag for P240'
F_P245		 'Imputation Flag for P245'
F_P250		 'Imputation Flag for P250'
F_P255		 'Imputation Flag for P255'
F_P260		 'Imputation Flag for P260'
F_P265		 'Imputation Flag for P265'
F_P270		 'Imputation Flag for P270'
F_P275		 'Imputation Flag for P275'
F_P280		 'Imputation Flag for P280'
F_P285		 'Imputation Flag for P285'
F_P290		 'Imputation Flag for P290'
F_P295		 'Imputation Flag for P295'
F_P300		 'Imputation Flag for P300'
F_P305		 'Imputation Flag for P305'
F_P310		 'Imputation Flag for P310'
F_P315		 'Imputation Flag for P315'
F_P320		 'Imputation Flag for P320'
F_P325		 'Imputation Flag for P325'
F_P330		 'Imputation Flag for P330'
F_P340		 'Imputation Flag for P340'
F_P345		 'Imputation Flag for P345'
F_P350		 'Imputation Flag for P350'
F_P355		 'Imputation Flag for P355'
F_P360		 'Imputation Flag for P360'
F_P365		 'Imputation Flag for P365'
F_P370		 'Imputation Flag for P370'
F_P375		 'Imputation Flag for P375'
F_P380		 'Imputation Flag for P380'
F_P385		 'Imputation Flag for P385'
F_P390		 'Imputation Flag for P390'
F_P395		 'Imputation Flag for P395'
F_P400		 'Imputation Flag for P400'
F_P405		 'Imputation Flag for P405'
F_P410		 'Imputation Flag for P410'
F_P415		 'Imputation Flag for P415'
F_P420		 'Imputation Flag for P420'
F_P425		 'Imputation Flag for P425'
F_P430		 'Imputation Flag for P430'
F_P435		 'Imputation Flag for P435'
F_P440		 'Imputation Flag for P440'
F_P445		 'Imputation Flag for P445'
F_P450		 'Imputation Flag for P450'
F_P455		 'Imputation Flag for P455'
F_P460		 'Imputation Flag for P460'
F_P465		 'Imputation Flag for P465'
F_P470		 'Imputation Flag for P470'
F_P475		 'Imputation Flag for P475'
F_P480		 'Imputation Flag for P480'
F_P485		 'Imputation Flag for P485'
F_P490		 'Imputation Flag for P490'
F_P495		 'Imputation Flag for P495'
F_P500		 'Imputation Flag for P500'
F_P505		 'Imputation Flag for P505'
F_P510		 'Imputation Flag for P510'
F_P515		 'Imputation Flag for P515'
F_P520		 'Imputation Flag for P520'
F_P525		 'Imputation Flag for P525'
F_P530		 'Imputation Flag for P530'
F_P535		 'Imputation Flag for P535'
F_P540		 'Imputation Flag for P540'
F_P545		 'Imputation Flag for P545'
F_P550		 'Imputation Flag for P550'
F_P555		 'Imputation Flag for P555'
F_P560		 'Imputation Flag for P560'
F_P565		 'Imputation Flag for P565'
F_P570		 'Imputation Flag for P570'
F_P575		 'Imputation Flag for P575'
F_P580		 'Imputation Flag for P580'
F_P585		 'Imputation Flag for P585'
F_P590		 'Imputation Flag for P590'
F_P595		 'Imputation Flag for P595'
F_P600		 'Imputation Flag for P600'
F_P605		 'Imputation Flag for P605'
F_P610		 'Imputation Flag for P610'
F_P615		 'Imputation Flag for P615'
F_P620		 'Imputation Flag for P620'
F_P625		 'Imputation Flag for P625'
F_P630		 'Imputation Flag for P630'
F_P635		 'Imputation Flag for P635'
F_P640		 'Imputation Flag for P640'
F_P645		 'Imputation Flag for P645'
.

Value labels
/Qstfip
'1'  '1 Alabama'
'2'  '2 Alaska'
'4'  '4 Arizona'
'5'  '5 Arkansas'
'6'  '6 California'
'8'  '8 Colorado'
'9'  '9 Connecticut'
'10'  '10 Delaware'
'11'  '11 District of Columbia'
'12'  '12 Florida'
'13'  '13 Georgia'
'15'  '15 Hawaii'
'16'  '16 Idaho'
'17'  '17 Illinois'
'18'  '18 Indiana'
'19'  '19 Iowa'
'20'  '20 Kansas'
'21'  '21 Kentucky'
'22'  '22 Louisiana'
'23'  '23 Maine'
'24'  '24 Maryland'
'25'  '25 Massachusetts'
'26'  '26 Michigan'
'27'  '27 Minnesota'
'28'  '28 Mississippi'
'29'  '29 Missouri'
'30'  '30 Montana'
'31'  '31 Nebraska'
'32'  '32 Nevada'
'33'  '33 New Hampshire'
'34'  '34 New Jersey'
'35'  '35 New Mexico'
'36'  '36 New York'
'37'  '37 North Carolina'
'38'  '38 North Dakota'
'39'  '39 Ohio'
'40'  '40 Oklahoma'
'41'  '41 Oregon'
'42'  '42 Pennsylvania'
'44'  '44 Rhode Island'
'45'  '45 South Carolina'
'46'  '46 South Dakota'
'47'  '47 Tennessee'
'48'  '48 Texas'
'49'  '49 Utah'
'50'  '50 Vermont'
'51'  '51 Virginia'
'53'  '53 Washington'
'54'  '54 West Virginia'
'55'  '55 Wisconsin'
'56'  '56 Wyoming'
/Qstabb
' '  'Missing'
'AK'  'Alaska'
'AL'  'Alabama'
'AR'  'Arkansas'
'AZ'  'Arizona'
'CA'  'California'
'CO'  'Colorado'
'CT'  'Connecticut'
'DC'  'District of Columbia'
'DE'  'Delaware'
'FL'  'Florida'
'GA'  'Georgia'
'HI'  'Hawaii'
'IA'  'Iowa'
'ID'  'Idaho'
'IL'  'Illinois'
'IN'  'Indiana'
'KS'  'Kansas'
'KY'  'Kentucky'
'LA'  'Louisiana'
'MA'  'Massachusetts'
'MD'  'Maryland'
'ME'  'Maine'
'MI'  'Michigan'
'MN'  'Minnesota'
'MO'  'Missouri'
'MS'  'Mississippi'
'MT'  'Montana'
'NC'  'North Carolina'
'ND'  'North Dakota'
'NE'  'Nebraska'
'NH'  'New Hampshire'
'NJ'  'New Jersey'
'NM'  'New Mexico'
'NV'  'Nevada'
'NY'  'New York'
'OH'  'Ohio'
'OK'  'Oklahoma'
'OR'  'Oregon'
'PA'  'Pennsylvania'
'RI'  'Rhode Island'
'SC'  'South Carolina'
'SD'  'South Dakota'
'TN'  'Tennessee'
'TX'  'Texas'
'UT'  'Utah'
'VA'  'Virginia'
'VT'  'Vermont'
'WA'  'Washington'
'WI'  'Wisconsin'
'WV'  'West Virginia'
'WY'  'Wyoming'
/P415
'1' 'Reg. Elementary, Secondary'
'2' 'Montessori'
'3' 'Special Program Emphasis'
'4' 'Special Education'
'5' 'Vocational/Technical'
'6' 'Early Childhood Program/Day Care Center'
'7' 'Alternative'
/Commtype  
'1' 'Central City'
'2' 'Urban fringe or large town'
'3' 'Rural or small town'
/Qhigr6
'0' 'Ungraded or less than 1st grade'
'1' '1st grade'
'2' '2nd grade'
'3' '3rd grade'
'4' '4th grade'
'5' '5th grade'
'6' '6th grade'     
'7' '7th grade'     
'8' '8th grade '
'9' '9th grade'
'10' '10th grade'
'11' '11th grade'
'12' '12th grade'
/Qlogr6
'0' 'Ungraded or less than 1st grade'
'1' '1st grade'
'2' '2nd grade'
'3' '3rd grade'
'4' '4th grade'
'5' '5th grade'
'6' '6th grade'     
'7' '7th grade'     
'8' '8th grade '
'9' '9th grade'
'10' '10th grade'
'11' '11th grade'
'12' '12th grade'
/level
'1' 'Elementary'
'2' 'Secondary'
'3' 'Combined elementary and secondary'
/locale
'1' 'Large central city'  
'2' 'Mid-size central city'  
'3' 'Urban fringe of large city' 
'4' 'Urban Fringe of mid-size city'  
'5' 'Large town'  
'6' 'Small town'  
'7' 'Rural'  
/orient
'1' 'Roman Catholic'
'2' 'Amish'
'3' 'Assembly of God'
'4' 'Baptist'
'5' 'Calvinist'
'6' 'Christian (unspecified)'
'7' 'Church of Christ'
'8' 'Church of God'
'9' 'Disciples of Christ'
'10' 'Episcopal'
'11' 'Friends'
'12' 'Greek Orthodox'
'13' 'Islamic'
'14' 'Jewish'
'15' 'Latter Day Saints'
'16' 'Lutheran Church - Missouri Synod'
'17' 'Evangelical Lutheran Church in America'
'18' 'Wisconsin Evangelical Lutheran Synod'
'19' 'Other Lutheran'
'20' 'Mennonite'
'21' 'Methodist'
'22' 'Pentecostal'
'23' 'Presbyterian'
'24' 'Seventh-Day Adventist'
'25' 'Other'
'26' 'Nonreligiuos, for exceptional children'
'27' 'Nonreligious, Montessori'
'28' 'Other nonreligious'
/perminor
'1' 'None'
'2' '1-9 percent'
'3' '10-29 percent'
'4' '30-49 percent'
'5' '50 percent or more'
/region
'1' 'Northeast'
'2' 'Midwest'
'3' 'South'
'4' 'West'
/relig
'1' 'Catholic'
'2' 'Other religious'
'3' 'Nonsectarian'
/size
'1' 'Less than 150 students'
'2' '150 to 299 students'
'3' '300 to 499 students'
'4' '500 to 749 students'
'5' '750 or more'
/typology
'1' 'Catholic, parochial'
'2' 'Catholic, diocesan'
'3' 'Catholic, private'
'4' 'Other religious, conservative Christian'
'5' 'Other religious, affiliated'
'6' 'Other religious, not affiliated'
'7' 'Nonsectarian, regular school'
'8' 'Nonsectarian, special program'
'9' 'Nonsectarian, special education'
/tabflag1 tabflag2
'0' 'Included in tabulations'
'1' 'Not included in tabulations'
/F_P135  F_P140  F_P145 F_P150  F_P155  F_P160  F_P165 F_P170  
F_P175  F_P180  F_P185 F_P190  F_P195  F_P200  F_P205 F_P210
F_P215  F_P220 F_P225  F_P230  F_P235  F_P240  F_P245
F_P250  F_P255  F_P260  F_P265 F_P270  F_P275  F_P280  F_P285
F_P290  F_P295  F_P300  F_P305 F_P310  F_P315  F_P320  F_P325
F_P330  F_P335 F_P340  F_P345 F_P350  F_P355  F_P360  F_P365
F_P370  F_P375  F_P380  F_P385 F_P390  F_P395  F_P400  F_P405
F_P410  F_P415  F_P420  F_P425 F_P430  F_P435  F_P440  F_P445
F_P450  F_P455  F_P460  F_P465 F_P470  F_P475  F_P480  F_P485
F_P490  F_P495  F_P500  F_P505 F_P510  F_P515  F_P520  F_P525
F_P530  F_P535  F_P540  F_P545 F_P550  F_P555  F_P560  F_P565
F_P570  F_P575  F_P580  F_P585 F_P590  F_P595  F_P600  F_P605
F_P610  F_P615  F_P620  F_P625 F_P630  F_P635  F_P640  F_P645
'0' 'Not imputed  (original data)'
'1' 'Ratio adjustment of original data'
'2' 'Imputed -- data from other variables'
'3' 'Imputed -- donor value from another record'
'4' 'Clerical imputation'

.

**************************************************************************************************.
***   Change OUTFILE directory to where you wish the permanent SPSS data set to be located.    ***.
***   This location does not need to be in the same location as PSS9596_PU.TXT                         ***.
**************************************************************************************************.


CACHE.
EXECUTE.
FILE LABEL 'PSS9596_PU.sav'.
Save outfile 'C:\PUBLIC USE\PSS_DATA\PSS9596_PU.SAV'/COMPRESSED.

**************************************************************************************************.
***   The following lines of code have been commented out. If the user should wish to run file ***.
***   frequencies, or univariates they may submit these lines separtely or remove the "***"     ***.
***   characters preceding the "Frequencies" command before running this code.                  ***.
**************************************************************************************************.
***
Frequencies variables
QSTABB QSTFIP P415 COMMTYPE FRAME LEVEL LOCALE ORIENT PERMINOR QHIGR6
QLOGR6 REGION RELIG SIZE TABFLAG1 TABFLAG2 TYPOLOGY
F_P135  F_P140  F_P145 F_P150  F_P155  F_P160  F_P165 F_P170  
F_P175  F_P180  F_P185 F_P190  F_P195  F_P200  F_P205 F_P210
F_P215  F_P220 F_P225  F_P230  F_P235  F_P240  F_P245
F_P250  F_P255  F_P260  F_P265 F_P270  F_P275  F_P280  F_P285
F_P290  F_P295  F_P300  F_P305 F_P310  F_P315  F_P320  F_P325
F_P330  F_P335  F_P340  F_P345 F_P350  F_P355  F_P360  F_P365
F_P370  F_P375  F_P380  F_P385 F_P390  F_P395  F_P400  F_P405
F_P410  F_P415  F_P420  F_P425 F_P430  F_P435  F_P440  F_P445
F_P450  F_P455  F_P460  F_P465 F_P470  F_P475  F_P480  F_P485
F_P490  F_P495  F_P500  F_P505 F_P510  F_P515  F_P520  F_P525
F_P530  F_P535  F_P540  F_P545 F_P550  F_P555  F_P560  F_P565
F_P570  F_P575  F_P580  F_P585 F_P590  F_P595  F_P600  F_P605
F_P610  F_P615  F_P620  F_P625 F_P630  F_P635  F_P640  F_P645 
.

CACHE.
EXECUTE.



