**************************************************************************;
*** Created: June 27, 2006 10:15:11 AM                                 ***;
*** Modify the LIBNAME path below to point to your data file           ***;
*** Written by: Kforce Government Solutions							   ***;
*** Program Name: Read_PSS_9596_PU.sas                                 ***;
***																	   ***;	
*** Data file Name: PSS9596_PU.TXT                                     ***;
*** The Tab-delimited file which is specified in the program must      ***;
*** be saved in the directory specified by INFILE statement            ***;
***                                                                    ***;
*** SAS code was written for SAS version 9.1 or above.  Labels were    ***;
*** given a maximun length of 60 characters. If you are using a SAS    ***;
*** version before SAS 8.0, you should be aware that labels could      ***;
*** be truncated to 40 characters.  If so the user may wish to         ***;
*** abreviate labels so that they are unique and are descriptive.      ***;
***                                                                    ***;
*** This program provides frequency for all categorical variables.     ***;
*** Users should uncomment the frequency section to generate frequency ***;
*** tables.                                                            ***;
***                                                                    ***;
*** There may be missing data for some institutions due to parent-     ***;
*** child relations.                                                   ***;
**************************************************************************;
lIBNAME OUT1 'C:\PUBLIC USE\PSS_DATA';

     data OUT1.PSS9596_PU                             ;
     %let _EFIERR_ = 0; /* set the ERROR detection macro variable */
     infile 'C:\PUBLIC USE\PSS_DATA\TXT\PSS9596_PU.txt' delimiter='09'x MISSOVER DSD lrecl=32767
 firstobs=2 ;
        informat QPIN $8. ;
        informat QCITY $24. ;
        informat QSTABB $2. ;
        informat QSTFIP best32. ;
        informat QCNTY $3. ;
        informat QCNTNM $14. ;
        informat STCNTY $15. ;
        informat QZIP $10. ;
        informat SCHOOL best32. ;
        informat P135 best32. ;
        informat P140 best32. ;
        informat P145 best32. ;
        informat P150 best32. ;
        informat P155 best32. ;
        informat P160 best32. ;
        informat P165 best32. ;
        informat P170 best32. ;
        informat P175 best32. ;
        informat P180 best32. ;
        informat S_KG best32. ;
        informat P185 best32. ;
        informat P190 best32. ;
        informat P195 best32. ;
        informat P200 best32. ;
        informat P205 best32. ;
        informat P210 best32. ;
        informat P215 best32. ;
        informat P220 best32. ;
        informat P225 best32. ;
        informat P230 best32. ;
        informat P235 best32. ;
        informat P240 best32. ;
        informat P245 best32. ;
        informat P250 best32. ;
        informat P255 best32. ;
        informat P260 best32. ;
        informat P265 best32. ;
        informat P270 best32. ;
        informat P275 best32. ;
        informat P280 best32. ;
        informat P285 best32. ;
        informat P290 best32. ;
        informat P295 best32. ;
        informat P300 best32. ;
        informat P305 best32. ;
        informat P310 best32. ;
        informat P315 best32. ;
        informat P320 best32. ;
        informat P325 best32. ;
        informat P330 best32. ;
        informat P340 best32. ;
        informat P345 best32. ;
        informat P350 best32. ;
        informat P355 best32. ;
        informat P360 best32. ;
        informat P365 best32. ;
        informat P370 best32. ;
        informat P375 best32. ;
        informat P380 best32. ;
        informat P385 best32. ;
        informat P390 best32. ;
        informat P395 best32. ;
        informat P400 best32. ;
        informat P405 best32. ;
        informat P410 best32. ;
        informat P415 best32. ;
        informat P420 best32. ;
        informat P425 best32. ;
        informat P430 best32. ;
        informat P435 best32. ;
        informat P440 best32. ;
        informat P445 best32. ;
        informat P450 best32. ;
        informat P455 best32. ;
        informat P460 best32. ;
        informat P465 best32. ;
        informat P470 best32. ;
        informat P475 best32. ;
        informat P480 best32. ;
        informat P485 best32. ;
        informat P490 best32. ;
        informat P495 best32. ;
        informat P500 best32. ;
        informat P505 best32. ;
        informat P510 best32. ;
        informat P515 best32. ;
        informat P520 best32. ;
        informat P525 best32. ;
        informat P530 best32. ;
        informat P535 best32. ;
        informat P540 best32. ;
        informat P545 best32. ;
        informat P550 best32. ;
        informat P555 best32. ;
        informat P560 best32. ;
        informat P565 best32. ;
        informat P570 best32. ;
        informat P575 best32. ;
        informat P580 best32. ;
        informat P585 best32. ;
        informat P590 best32. ;
        informat P595 best32. ;
        informat P600 best32. ;
        informat P605 best32. ;
        informat P610 best32. ;
        informat P615 best32. ;
        informat P620 best32. ;
        informat P625 best32. ;
        informat P630 best32. ;
        informat P635 best32. ;
        informat P640 best32. ;
        informat P645 best32. ;
        informat P650 best32. ;
        informat COMMTYPE best32. ;
        informat FRAME $4. ;
        informat HOURS best32. ;
        informat LEVEL best32. ;
        informat LOCALE $1. ;
        informat MINOR best32. ;
        informat NUMSTUDS best32. ;
        informat NUMTEACH best32. ;
        informat ORIENT best32. ;
        informat P_INDIAN best32. ;
        informat P_ASIAN best32. ;
        informat P_HISP best32. ;
        informat P_BLACK best32. ;
        informat P_WHITE best32. ;
        informat PERMINOR best32. ;
        informat QHIGR6 best32. ;
        informat QLOGR6 best32. ;
        informat REGION best32. ;
        informat RELIG best32. ;
        informat SIZE best32. ;
        informat STTCH_RT best32. ;
        informat TABFLAG1 best32. ;
        informat TABFLAG2 best32. ;
        informat TYPOLOGY best32. ;
        informat QFNLWT best32. ;
        informat REPW1 best32. ;
        informat REPW2 best32. ;
        informat REPW3 best32. ;
        informat REPW4 best32. ;
        informat REPW5 best32. ;
        informat REPW6 best32. ;
        informat REPW7 best32. ;
        informat REPW8 best32. ;
        informat REPW9 best32. ;
        informat REPW10 best32. ;
        informat REPW11 best32. ;
        informat REPW12 best32. ;
        informat REPW13 best32. ;
        informat REPW14 best32. ;
        informat REPW15 best32. ;
        informat REPW16 best32. ;
        informat REPW17 best32. ;
        informat REPW18 best32. ;
        informat REPW19 best32. ;
        informat REPW20 best32. ;
        informat REPW21 best32. ;
        informat REPW22 best32. ;
        informat REPW23 best32. ;
        informat REPW24 best32. ;
        informat REPW25 best32. ;
        informat REPW26 best32. ;
        informat REPW27 best32. ;
        informat REPW28 best32. ;
        informat REPW29 best32. ;
        informat REPW30 best32. ;
        informat REPW31 best32. ;
        informat REPW32 best32. ;
        informat REPW33 best32. ;
        informat REPW34 best32. ;
        informat REPW35 best32. ;
        informat REPW36 best32. ;
        informat REPW37 best32. ;
        informat REPW38 best32. ;
        informat REPW39 best32. ;
        informat REPW40 best32. ;
        informat REPW41 best32. ;
        informat REPW42 best32. ;
        informat REPW43 best32. ;
        informat REPW44 best32. ;
        informat REPW45 best32. ;
        informat REPW46 best32. ;
        informat REPW47 best32. ;
        informat REPW48 best32. ;
        informat F_P135 best32. ;
        informat F_P140 best32. ;
        informat F_P145 best32. ;
        informat F_P150 best32. ;
        informat F_P155 best32. ;
        informat F_P160 best32. ;
        informat F_P165 best32. ;
        informat F_P170 best32. ;
        informat F_P175 best32. ;
        informat F_P180 best32. ;
        informat F_P185 best32. ;
        informat F_P190 best32. ;
        informat F_P195 best32. ;
        informat F_P200 best32. ;
        informat F_P205 best32. ;
        informat F_P210 best32. ;
        informat F_P215 best32. ;
        informat F_P220 best32. ;
        informat F_P225 best32. ;
        informat F_P230 best32. ;
        informat F_P235 best32. ;
        informat F_P240 best32. ;
        informat F_P245 best32. ;
        informat F_P250 best32. ;
        informat F_P255 best32. ;
        informat F_P260 best32. ;
        informat F_P265 best32. ;
        informat F_P270 best32. ;
        informat F_P275 best32. ;
        informat F_P280 best32. ;
        informat F_P285 best32. ;
        informat F_P290 best32. ;
        informat F_P295 best32. ;
        informat F_P300 best32. ;
        informat F_P305 best32. ;
        informat F_P310 best32. ;
        informat F_P315 best32. ;
        informat F_P320 best32. ;
        informat F_P325 best32. ;
        informat F_P330 best32. ;
        informat F_P340 best32. ;
        informat F_P345 best32. ;
        informat F_P350 best32. ;
        informat F_P355 best32. ;
        informat F_P360 best32. ;
        informat F_P365 best32. ;
        informat F_P370 best32. ;
        informat F_P375 best32. ;
        informat F_P380 best32. ;
        informat F_P385 best32. ;
        informat F_P390 best32. ;
        informat F_P395 best32. ;
        informat F_P400 best32. ;
        informat F_P405 best32. ;
        informat F_P410 best32. ;
        informat F_P415 best32. ;
        informat F_P420 best32. ;
        informat F_P425 best32. ;
        informat F_P430 best32. ;
        informat F_P435 best32. ;
        informat F_P440 best32. ;
        informat F_P445 best32. ;
        informat F_P450 best32. ;
        informat F_P455 best32. ;
        informat F_P460 best32. ;
        informat F_P465 best32. ;
        informat F_P470 best32. ;
        informat F_P475 best32. ;
        informat F_P480 best32. ;
        informat F_P485 best32. ;
        informat F_P490 best32. ;
        informat F_P495 best32. ;
        informat F_P500 best32. ;
        informat F_P505 best32. ;
        informat F_P510 best32. ;
        informat F_P515 best32. ;
        informat F_P520 best32. ;
        informat F_P525 best32. ;
        informat F_P530 best32. ;
        informat F_P535 best32. ;
        informat F_P540 best32. ;
        informat F_P545 best32. ;
        informat F_P550 best32. ;
        informat F_P555 best32. ;
        informat F_P560 best32. ;
        informat F_P565 best32. ;
        informat F_P570 best32. ;
        informat F_P575 best32. ;
        informat F_P580 best32. ;
        informat F_P585 best32. ;
        informat F_P590 best32. ;
        informat F_P595 best32. ;
        informat F_P600 best32. ;
        informat F_P605 best32. ;
        informat F_P610 best32. ;
        informat F_P615 best32. ;
        informat F_P620 best32. ;
        informat F_P625 best32. ;
        informat F_P630 best32. ;
        informat F_P635 best32. ;
        informat F_P640 best32. ;
        informat F_P645 best32. ;

        format QPIN $8. ;
        format QCITY $24. ;
        format QSTABB $2. ;
        format QSTFIP best32. ;
        format QCNTY $3. ;
        format QCNTNM $14. ;
        format STCNTY $15. ;
        format QZIP $10. ;
        format SCHOOL best12. ;
        format P135 best32. ;
        format P140 best32. ;
        format P145 best12. ;
        format P150 best12. ;
        format P155 best12. ;
        format P160 best12. ;
        format P165 best12. ;
        format P170 best12. ;
        format P175 best12. ;
        format P180 best12. ;
        format S_KG best12. ;
        format P185 best12. ;
        format P190 best12. ;
        format P195 best12. ;
        format P200 best12. ;
        format P205 best12. ;
        format P210 best12. ;
        format P215 best12. ;
        format P220 best12. ;
        format P225 best12. ;
        format P230 best12. ;
        format P235 best12. ;
        format P240 best12. ;
        format P245 best12. ;
        format P250 best12. ;
        format P255 best12. ;
        format P260 best12. ;
        format P265 best12. ;
        format P270 best12. ;
        format P275 best12. ;
        format P280 best12. ;
        format P285 best12. ;
        format P290 best12. ;
        format P295 best12. ;
        format P300 best12. ;
        format P305 best12. ;
        format P310 best12. ;
        format P315 best12. ;
        format P320 best12. ;
        format P325 best12. ;
        format P330 best12. ;
        format P340 best12. ;
        format P345 best12. ;
        format P350 best12. ;
        format P355 best12. ;
        format P360 best12. ;
        format P365 best12. ;
        format P370 best12. ;
        format P375 best12. ;
        format P380 best12. ;
        format P385 best12. ;
        format P390 best12. ;
        format P395 best12. ;
        format P400 best12. ;
        format P405 best12. ;
        format P410 best12. ;
        format P415 best12. ;
        format P420 best32. ;
        format P425 best12. ;
        format P430 best12. ;
        format P435 best12. ;
        format P440 best12. ;
        format P445 best32. ;
        format P450 best32. ;
        format P455 best32. ;
        format P460 best32. ;
        format P465 best12. ;
        format P470 best32. ;
        format P475 best32. ;
        format P480 best12. ;
        format P485 best32. ;
        format P490 best32. ;
        format P495 best32. ;
        format P500 best32. ;
        format P505 best32. ;
        format P510 best32. ;
        format P515 best32. ;
        format P520 best32. ;
        format P525 best32. ;
        format P530 best12. ;
        format P535 best12. ;
        format P540 best32. ;
        format P545 best32. ;
        format P550 best32. ;
        format P555 best12. ;
        format P560 best12. ;
        format P565 best12. ;
        format P570 best12. ;
        format P575 best12. ;
        format P580 best32. ;
        format P585 best32. ;
        format P590 best32. ;
        format P595 best32. ;
        format P600 best32. ;
        format P605 best32. ;
        format P610 best32. ;
        format P615 best32. ;
        format P620 best32. ;
        format P625 best12. ;
        format P630 best32. ;
        format P635 best12. ;
        format P640 best12. ;
        format P645 best12. ;
        format P650 best12. ;
        format COMMTYPE best12. ;
        format FRAME $4. ;
        format HOURS best12. ;
        format LEVEL best12. ;
        format LOCALE $1. ;
        format MINOR best12. ;
        format NUMSTUDS best12. ;
        format NUMTEACH best12. ;
        format ORIENT best12. ;
        format P_INDIAN best12. ;
        format P_ASIAN best12. ;
        format P_HISP best12. ;
        format P_BLACK best12. ;
        format P_WHITE best12. ;
        format PERMINOR best12. ;
        format QHIGR6 best12. ;
        format QLOGR6 best12. ;
        format REGION best12. ;
        format RELIG best12. ;
        format SIZE best12. ;
        format STTCH_RT best12. ;
        format TABFLAG1 best12. ;
        format TABFLAG2 best12. ;
        format TYPOLOGY best12. ;
        format QFNLWT best12. ;
        format REPW1 best12. ;
        format REPW2 best12. ;
        format REPW3 best12. ;
        format REPW4 best12. ;
        format REPW5 best12. ;
        format REPW6 best12. ;
        format REPW7 best12. ;
        format REPW8 best12. ;
        format REPW9 best12. ;
        format REPW10 best12. ;
        format REPW11 best12. ;
        format REPW12 best12. ;
        format REPW13 best12. ;
        format REPW14 best12. ;
        format REPW15 best12. ;
        format REPW16 best12. ;
        format REPW17 best12. ;
        format REPW18 best12. ;
        format REPW19 best12. ;
        format REPW20 best12. ;
        format REPW21 best12. ;
        format REPW22 best12. ;
        format REPW23 best12. ;
        format REPW24 best12. ;
        format REPW25 best12. ;
        format REPW26 best12. ;
        format REPW27 best12. ;
        format REPW28 best12. ;
        format REPW29 best12. ;
        format REPW30 best12. ;
        format REPW31 best12. ;
        format REPW32 best12. ;
        format REPW33 best12. ;
        format REPW34 best12. ;
        format REPW35 best12. ;
        format REPW36 best12. ;
        format REPW37 best12. ;
        format REPW38 best12. ;
        format REPW39 best12. ;
        format REPW40 best12. ;
        format REPW41 best12. ;
        format REPW42 best12. ;
        format REPW43 best12. ;
        format REPW44 best12. ;
        format REPW45 best12. ;
        format REPW46 best12. ;
        format REPW47 best12. ;
        format REPW48 best12. ;
        format F_P135 best12. ;
        format F_P140 best12. ;
        format F_P145 best12. ;
        format F_P150 best12. ;
        format F_P155 best12. ;
        format F_P160 best12. ;
        format F_P165 best12. ;
        format F_P170 best12. ;
        format F_P175 best12. ;
        format F_P180 best12. ;
        format F_P185 best12. ;
        format F_P190 best12. ;
        format F_P195 best12. ;
        format F_P200 best12. ;
        format F_P205 best12. ;
        format F_P210 best12. ;
        format F_P215 best12. ;
        format F_P220 best12. ;
        format F_P225 best12. ;
        format F_P230 best12. ;
        format F_P235 best12. ;
        format F_P240 best12. ;
        format F_P245 best12. ;
        format F_P250 best12. ;
        format F_P255 best12. ;
        format F_P260 best12. ;
        format F_P265 best12. ;
        format F_P270 best12. ;
        format F_P275 best12. ;
        format F_P280 best12. ;
        format F_P285 best12. ;
        format F_P290 best12. ;
        format F_P295 best12. ;
        format F_P300 best12. ;
        format F_P305 best12. ;
        format F_P310 best12. ;
        format F_P315 best12. ;
        format F_P320 best12. ;
        format F_P325 best12. ;
        format F_P330 best12. ;
        format F_P340 best12. ;
        format F_P345 best12. ;
        format F_P350 best12. ;
        format F_P355 best12. ;
        format F_P360 best12. ;
        format F_P365 best12. ;
        format F_P370 best12. ;
        format F_P375 best12. ;
        format F_P380 best12. ;
        format F_P385 best12. ;
        format F_P390 best12. ;
        format F_P395 best12. ;
        format F_P400 best12. ;
        format F_P405 best12. ;
        format F_P410 best12. ;
        format F_P415 best12. ;
        format F_P420 best12. ;
        format F_P425 best12. ;
        format F_P430 best12. ;
        format F_P435 best12. ;
        format F_P440 best12. ;
        format F_P445 best12. ;
        format F_P450 best12. ;
        format F_P455 best12. ;
        format F_P460 best12. ;
        format F_P465 best12. ;
        format F_P470 best12. ;
        format F_P475 best12. ;
        format F_P480 best12. ;
        format F_P485 best12. ;
        format F_P490 best12. ;
        format F_P495 best12. ;
        format F_P500 best12. ;
        format F_P505 best12. ;
        format F_P510 best12. ;
        format F_P515 best12. ;
        format F_P520 best12. ;
        format F_P525 best12. ;
        format F_P530 best12. ;
        format F_P535 best12. ;
        format F_P540 best12. ;
        format F_P545 best12. ;
        format F_P550 best12. ;
        format F_P555 best12. ;
        format F_P560 best12. ;
        format F_P565 best12. ;
        format F_P570 best12. ;
        format F_P575 best12. ;
        format F_P580 best12. ;
        format F_P585 best12. ;
        format F_P590 best12. ;
        format F_P595 best12. ;
        format F_P600 best12. ;
        format F_P605 best12. ;
        format F_P610 best12. ;
        format F_P615 best12. ;
        format F_P620 best12. ;
        format F_P625 best12. ;
        format F_P630 best12. ;
        format F_P635 best12. ;
        format F_P640 best12. ;
        format F_P645 best12. ;
     input
                 QPIN $
                 QCITY $
                 QSTABB $
                 QSTFIP
                 QCNTY $
                 QCNTNM $
                 STCNTY $
                 QZIP $
                 SCHOOL
                 P135 
                 P140 
                 P145
                 P150
                 P155
                 P160
                 P165
                 P170
                 P175
                 P180
                 S_KG
                 P185
                 P190
                 P195
                 P200
                 P205
                 P210
                 P215
                 P220
                 P225
                 P230
                 P235
                 P240
                 P245
                 P250
                 P255
                 P260
                 P265
                 P270
                 P275
                 P280
                 P285
                 P290
                 P295
                 P300
                 P305
                 P310
                 P315
                 P320
                 P325
                 P330
                 P340
                 P345
                 P350
                 P355
                 P360
                 P365
                 P370
                 P375
                 P380
                 P385
                 P390
                 P395
                 P400
                 P405
                 P410
                 P415
                 P420 
                 P425
                 P430
                 P435
                 P440
                 P445 
                 P450 
                 P455 
                 P460 
                 P465
                 P470 
                 P475 
                 P480
                 P485 
                 P490 
                 P495 
                 P500 
                 P505 
                 P510 
                 P515 
                 P520 
                 P525 
                 P530
                 P535
                 P540 
                 P545 
                 P550 
                 P555
                 P560
                 P565
                 P570
                 P575
                 P580 
                 P585 
                 P590 
                 P595 
                 P600 
                 P605 
                 P610 
                 P615 
                 P620 
                 P625
                 P630 
                 P635
                 P640
                 P645
                 P650
                 COMMTYPE
                 FRAME $
                 HOURS
                 LEVEL
                 LOCALE $
                 MINOR
                 NUMSTUDS
                 NUMTEACH
                 ORIENT
                 P_INDIAN
                 P_ASIAN
                 P_HISP
                 P_BLACK
                 P_WHITE
                 PERMINOR
                 QHIGR6
                 QLOGR6
                 REGION
                 RELIG
                 SIZE
                 STTCH_RT
                 TABFLAG1
                 TABFLAG2
                 TYPOLOGY
                 QFNLWT
                 REPW1
                 REPW2
                 REPW3
                 REPW4
                 REPW5
                 REPW6
                 REPW7
                 REPW8
                 REPW9
                 REPW10
                 REPW11
                 REPW12
                 REPW13
                 REPW14
                 REPW15
                 REPW16
                 REPW17
                 REPW18
                 REPW19
                 REPW20
                 REPW21
                 REPW22
                 REPW23
                 REPW24
                 REPW25
                 REPW26
                 REPW27
                 REPW28
                 REPW29
                 REPW30
                 REPW31
                 REPW32
                 REPW33
                 REPW34
                 REPW35
                 REPW36
                 REPW37
                 REPW38
                 REPW39
                 REPW40
                 REPW41
                 REPW42
                 REPW43
                 REPW44
                 REPW45
                 REPW46
                 REPW47
                 REPW48
                 F_P135
                 F_P140
                 F_P145
                 F_P150
                 F_P155
                 F_P160
                 F_P165
                 F_P170
                 F_P175
                 F_P180
                 F_P185
                 F_P190
                 F_P195
                 F_P200
                 F_P205
                 F_P210
                 F_P215
                 F_P220
                 F_P225
                 F_P230
                 F_P235
                 F_P240
                 F_P245
                 F_P250
                 F_P255
                 F_P260
                 F_P265
                 F_P270
                 F_P275
                 F_P280
                 F_P285
                 F_P290
                 F_P295
                 F_P300
                 F_P305
                 F_P310
                 F_P315
                 F_P320
                 F_P325
                 F_P330
                 F_P340
                 F_P345
                 F_P350
                 F_P355
                 F_P360
                 F_P365
                 F_P370
                 F_P375
                 F_P380
                 F_P385
                 F_P390
                 F_P395
                 F_P400
                 F_P405
                 F_P410
                 F_P415
                 F_P420
                 F_P425
                 F_P430
                 F_P435
                 F_P440
                 F_P445
                 F_P450
                 F_P455
                 F_P460
                 F_P465
                 F_P470
                 F_P475
                 F_P480
                 F_P485
                 F_P490
                 F_P495
                 F_P500
                 F_P505
                 F_P510
                 F_P515
                 F_P520
                 F_P525
                 F_P530
                 F_P535
                 F_P540
                 F_P545
                 F_P550
                 F_P555
                 F_P560
                 F_P565
                 F_P570
                 F_P575
                 F_P580
                 F_P585
                 F_P590
                 F_P595
                 F_P600
                 F_P605
                 F_P610
                 F_P615
                 F_P620
                 F_P625
                 F_P630
                 F_P635
                 F_P640
                 F_P645
     ;
     if _ERROR_ then call symputx('_EFIERR_',1);  /* set ERROR detection macro variable */
Label
QPIN		= 'Permanent Identification Number'
QCITY		= 'City of Mailing Address'
QSTABB		= 'State Postal Code of Mailing Address'
QSTFIP		= 'Fips State Code'
QCNTY		= 'Fips County Code'
QCNTNM		= 'County Name'
STCNTY		= 'Fips State/County Code'
QZIP		= 'Zip Code of Mailing Address (Zip + 4)'
SCHOOL		= 'School Counter'
P135		= '5A Ungraded Offered'
P140		= '5A Ungraded Enrollment'
P145		= '5B Nursery/Prekindergarten Offered'
P150		= '5B Nursery/Prekindergarten Enrollment'
P155		= '5C Transitional Kindergarten Offered'
P160		= '5C Transitional Kindergarten Enrollment'
P165		= '5D Kindergarten Offered'
P170		= '5D Kindergarten Enrollment'
P175		= '5E Transitional First Grade Offered'
P180		= '5E Transitional First Grade Enrollment'
S_KG		= 'Total Kindergarten Enrollment'
P185		= '5F First Grade Offered'
P190		= '5F First Grade Enrollment'
P195		= '5G Second Grade Offered'
P200		= '5G Second Grade Enrollment'
P205		= '5H Third Grade Offered'
P210		= '5H Third Grade Enrollment'
P215		= '5I Fourth Grade Offered'
P220		= '5I Fourth Grade Enrollment'
P225		= '5J Fifth Grade Offered'
P230		= '5J Fifth Grade Enrollment'
P235		= '5K Sixth Grade Offered'
P240		= '5K Sixth Grade Enrollment'
P245		= '5L Seventh Grade Offered'
P250		= '5L Seventh Grade Enrollment'
P255		= '5M Eighth Grade Offered'
P260		= '5M Eighth Grade Enrollment'
P265		= '5N Ninth Grade Offered'
P270		= '5N Ninth Grade Enrollment'
P275		= '5O Tenth Grade Offered'
P280		= '5O Tenth Grade Enrollment'
P285		= '5P Eleventh Grade Offered'
P290		= '5P Eleventh Grade Enrollment'
P295		= '5Q Twelfth Grade Offered'
P300		= '5Q Twelfth Grade Enrollment'
P305		= '6 Total Student Enrollment'
P310		= '7A Kindergarten,Trans Kind or Trans Firs'
P315		= '7B Half Day or Full Day'
P320		= '7C Days Per Week'
P325		= '8A Students in 12th Grade Last Year'
P330		= '8B How Many in 12th Grade Last Year'
P340		= '8D How Many Applied To College'
P345		= '9A Am Indian/Alaska Native Students'
P350		= '9B Asian or Pacific Islander Students'
P355		= '9C Hispanic Students'
P360		= '9D Black Students'
P365		= '9E White Students'
P370		= '10 Days in School Year for Students'
P375		= '11 Hours in School Day for Students'
P380		= '11 Minutes in School Day for Students'
P385		= '12 Full-Time Teachers'
P390		= '12 More than 3/4 Time Teachers'
P395		= '12 More than 1/2 Time Teachers'
P400		= '12 More than 1/4 Time Teachers'
P405		= '12 Less than 1/4 Time Teachers'
P410		= '12 Total Number of Teachers'
P415		= '13A Type of School'
P420		= '13B School Support Home Schooling'
P425		= '14 Is School Located in Private Home'
P430		= '15A Does School Have Religious orientation'
P435		= '15B Sch formally Affiliated w/Religious'
P440		= '15C Schools Religious orientation/Affiliation'
P445		= '15D What Type of Catholic School'
P450		= '16 Accelerated Christian Education'
P455		= '16 Alternative School Network'
P460		= '16 Natl Coalition of Alt Community Sch'
P465		= '16 American Assn of Christian Schools'
P470		= '16 American Montessori Society'
P475		= '16 Other Montessori Associations'
P480		= '16 Assn of Christian Schools Internatl'
P485		= '16 Assn of Military Colleges and Schools'
P490		= '16 Bilingual School Association'
P495		= '16 Council of Bilingual Education'
P500		= '16 Other Assns for Bilingual Education'
P505		= '16 Christian Schools International'
P510		= '16 Council for Exceptional Children'
P515		= '16 Natl Assn of Private Schls/Ex Childre'
P520		= '16 Other Assns for Exceptional Children'
P525		= '16 Council of Islamic Schls in N. Americ'
P530		= '16 Natl Assn for the Ed of Young Childre'
P535		= '16 Other Early Childhood Education Assns'
P540		= '16 European Council for Internatl School'
P545		= '16 Other Assns for International Schools'
P550		= '16 Friends Council on Education'
P555		= '16 Gen Conference of 7th-Day Adventist C'
P560		= '16 National Assn of Episcopal Schools'
P565		= '16 National Assn of Independent Schools'
P570		= '16 Natl Independent Private School Assn'
P575		= '16 Other Independent School Associations'
P580		= '16 National Assn of Laboratory Schools'
P585		= '16 National Catholic Educational Assn'
P590		= '16 Jesuit Secondary Education Assn'
P595		= '16 Natl Center for Neighborhood Enterpri'
P600		= '16 National Federation of Church Schools'
P605		= '16 National Society of Hebrew Day School'
P610		= '16 Solomon Schechter Day Schools'
P615		= '16 Other Jewish School Associations'
P620		= '16 Oral Roberts Univ Educational Fellows'
P625		= '16 Other Christian School Associations'
P630		= '16 Other Religious School Associations'
P635		= '16 Other Nonreligious School Association'
P640		= '16 None of the Above Associations'
P645		= '17 What Year Was School Founded'
P650		= '18 Minutes To Complete Questionnaire'
COMMTYPE	= 'Community Type'
FRAME		= 'Universe Frame To Which School Belongs'
HOURS		= 'Length of School Day in Hours'
LEVEL		= 'Level of Instruction'
LOCALE		= 'New Urbanicity Defined (Census Assigned)'
MINOR		= 'Total Minority Students'
NUMSTUDS	= 'Total No. of Students in Schl (K-12, Ug)'
NUMTEACH	= 'Total No. of Full-Time Equiv. Tchrs Ftes'
ORIENT		= 'School Orientation'
P_INDIAN	= 'Percent Am Indian/Alaskan Native Stdts'
P_ASIAN		= 'Percent Asian or Pacific Islander Stdts'
P_HISP		= 'Percent Hispanic Students'
P_BLACK		= 'Percent Black Students'
P_WHITE		= 'Percent White Students'
PERMINOR	= 'Percent Minority Students (Recode)'
QHIGR6		= '1996 Highest Grade Level Recode'
QLOGR6		= '1996 Lowest Grade Level Recode'
REGION		= 'Census Region'
RELIG		= 'School Affiliation'
SIZE		= 'Size of School (Enrollment Recode)'
STTCH_RT	= 'Student/Teacher Ratio'
TABFLAG1	= 'Schl offrs Grades Ug, 1 + - Traditional'
TABFLAG2	= 'Schl offrs Grades K or Lower - All Pss'
TYPOLOGY	= 'School Typology'
QFNLWT		= 'Final Weight for School'
REPW1		= 'Replicate Weight 1'
REPW2		= 'Replicate Weight 2'
REPW3		= 'Replicate Weight 3'
REPW4		= 'Replicate Weight 4'
REPW5		= 'Replicate Weight 5'
REPW6		= 'Replicate Weight 6'
REPW7		= 'Replicate Weight 7'
REPW8		= 'Replicate Weight 8'
REPW9		= 'Replicate Weight 9'
REPW10		= 'Replicate Weight 10'
REPW11		= 'Replicate Weight 11'
REPW12		= 'Replicate Weight 12'
REPW13		= 'Replicate Weight 13'
REPW14		= 'Replicate Weight 14'
REPW15		= 'Replicate Weight 15'
REPW16		= 'Replicate Weight 16'
REPW17		= 'Replicate Weight 17'
REPW18		= 'Replicate Weight 18'
REPW19		= 'Replicate Weight 19'
REPW20		= 'Replicate Weight 20'
REPW21		= 'Replicate Weight 21'
REPW22		= 'Replicate Weight 22'
REPW23		= 'Replicate Weight 23'
REPW24		= 'Replicate Weight 24'
REPW25		= 'Replicate Weight 25'
REPW26		= 'Replicate Weight 26'
REPW27		= 'Replicate Weight 27'
REPW28		= 'Replicate Weight 28'
REPW29		= 'Replicate Weight 29'
REPW30		= 'Replicate Weight 30'
REPW31		= 'Replicate Weight 31'
REPW32		= 'Replicate Weight 32'
REPW33		= 'Replicate Weight 33'
REPW34		= 'Replicate Weight 34'
REPW35		= 'Replicate Weight 35'
REPW36		= 'Replicate Weight 36'
REPW37		= 'Replicate Weight 37'
REPW38		= 'Replicate Weight 38'
REPW39		= 'Replicate Weight 39'
REPW40		= 'Replicate Weight 40'
REPW41		= 'Replicate Weight 41'
REPW42		= 'Replicate Weight 42'
REPW43		= 'Replicate Weight 43'
REPW44		= 'Replicate Weight 44'
REPW45		= 'Replicate Weight 45'
REPW46		= 'Replicate Weight 46'
REPW47		= 'Replicate Weight 47'
REPW48		= 'Replicate Weight 48'
F_P135		= 'Imputation Flag for P135'
F_P140		= 'Imputation Flag for P140'
F_P145		= 'Imputation Flag for P145'
F_P150		= 'Imputation Flag for P150'
F_P155		= 'Imputation Flag for P155'
F_P160		= 'Imputation Flag for P160'
F_P165		= 'Imputation Flag for P165'
F_P170		= 'Imputation Flag for P170'
F_P175		= 'Imputation Flag for P175'
F_P180		= 'Imputation Flag for P180'
F_P185		= 'Imputation Flag for P185'
F_P190		= 'Imputation Flag for P190'
F_P195		= 'Imputation Flag for P195'
F_P200		= 'Imputation Flag for P200'
F_P205		= 'Imputation Flag for P205'
F_P210		= 'Imputation Flag for P210'
F_P215		= 'Imputation Flag for P215'
F_P220		= 'Imputation Flag for P220'
F_P225		= 'Imputation Flag for P225'
F_P230		= 'Imputation Flag for P230'
F_P235		= 'Imputation Flag for P235'
F_P240		= 'Imputation Flag for P240'
F_P245		= 'Imputation Flag for P245'
F_P250		= 'Imputation Flag for P250'
F_P255		= 'Imputation Flag for P255'
F_P260		= 'Imputation Flag for P260'
F_P265		= 'Imputation Flag for P265'
F_P270		= 'Imputation Flag for P270'
F_P275		= 'Imputation Flag for P275'
F_P280		= 'Imputation Flag for P280'
F_P285		= 'Imputation Flag for P285'
F_P290		= 'Imputation Flag for P290'
F_P295		= 'Imputation Flag for P295'
F_P300		= 'Imputation Flag for P300'
F_P305		= 'Imputation Flag for P305'
F_P310		= 'Imputation Flag for P310'
F_P315		= 'Imputation Flag for P315'
F_P320		= 'Imputation Flag for P320'
F_P325		= 'Imputation Flag for P325'
F_P330		= 'Imputation Flag for P330'
F_P340		= 'Imputation Flag for P340'
F_P345		= 'Imputation Flag for P345'
F_P350		= 'Imputation Flag for P350'
F_P355		= 'Imputation Flag for P355'
F_P360		= 'Imputation Flag for P360'
F_P365		= 'Imputation Flag for P365'
F_P370		= 'Imputation Flag for P370'
F_P375		= 'Imputation Flag for P375'
F_P380		= 'Imputation Flag for P380'
F_P385		= 'Imputation Flag for P385'
F_P390		= 'Imputation Flag for P390'
F_P395		= 'Imputation Flag for P395'
F_P400		= 'Imputation Flag for P400'
F_P405		= 'Imputation Flag for P405'
F_P410		= 'Imputation Flag for P410'
F_P415		= 'Imputation Flag for P415'
F_P420		= 'Imputation Flag for P420'
F_P425		= 'Imputation Flag for P425'
F_P430		= 'Imputation Flag for P430'
F_P435		= 'Imputation Flag for P435'
F_P440		= 'Imputation Flag for P440'
F_P445		= 'Imputation Flag for P445'
F_P450		= 'Imputation Flag for P450'
F_P455		= 'Imputation Flag for P455'
F_P460		= 'Imputation Flag for P460'
F_P465		= 'Imputation Flag for P465'
F_P470		= 'Imputation Flag for P470'
F_P475		= 'Imputation Flag for P475'
F_P480		= 'Imputation Flag for P480'
F_P485		= 'Imputation Flag for P485'
F_P490		= 'Imputation Flag for P490'
F_P495		= 'Imputation Flag for P495'
F_P500		= 'Imputation Flag for P500'
F_P505		= 'Imputation Flag for P505'
F_P510		= 'Imputation Flag for P510'
F_P515		= 'Imputation Flag for P515'
F_P520		= 'Imputation Flag for P520'
F_P525		= 'Imputation Flag for P525'
F_P530		= 'Imputation Flag for P530'
F_P535		= 'Imputation Flag for P535'
F_P540		= 'Imputation Flag for P540'
F_P545		= 'Imputation Flag for P545'
F_P550		= 'Imputation Flag for P550'
F_P555		= 'Imputation Flag for P555'
F_P560		= 'Imputation Flag for P560'
F_P565		= 'Imputation Flag for P565'
F_P570		= 'Imputation Flag for P570'
F_P575		= 'Imputation Flag for P575'
F_P580		= 'Imputation Flag for P580'
F_P585		= 'Imputation Flag for P585'
F_P590		= 'Imputation Flag for P590'
F_P595		= 'Imputation Flag for P595'
F_P600		= 'Imputation Flag for P600'
F_P605		= 'Imputation Flag for P605'
F_P610		= 'Imputation Flag for P610'
F_P615		= 'Imputation Flag for P615'
F_P620		= 'Imputation Flag for P620'
F_P625		= 'Imputation Flag for P625'
F_P630		= 'Imputation Flag for P630'
F_P635		= 'Imputation Flag for P635'
F_P640		= 'Imputation Flag for P640'
F_P645		= 'Imputation Flag for P645';
Run;


Proc Format;
Value Fipsf 
	     		1 ="1 Alabama"
				2 ="2 Alaska"
				4 ="4 Arizona"
				5 ="5 Arkansas"
				6 ="6 California"
				8 ="8 Colorado"
				9 ="9 Connecticut"
				10 ="10 Delaware"
				11 ="11 District of Columbia"
				12 ="12 Florida"
				13 ="13 Georgia"
				15 ="15 Hawaii"
				16 ="16 Idaho"
				17 ="17 Illinois"
				18 ="18 Indiana"
				19 ="19 Iowa"
				20 ="20 Kansas"
				21 ="21 Kentucky"
				22 ="22 Louisiana"
				23 ="23 Maine"
				24 ="24 Maryland"
				25 ="25 Massachusetts"
				26 ="26 Michigan"
				27 ="27 Minnesota"
				28 ="28 Mississippi"
				29 ="29 Missouri"
				30 ="30 Montana"
				31 ="31 Nebraska"
				32 ="32 Nevada"
				33 ="33 New Hampshire"
				34 ="34 New Jersey"
				35 ="35 New Mexico"
				36 ="36 New York"
				37 ="37 North Carolina"
				38 ="38 North Dakota"
				39 ="39 Ohio"
				40 ="40 Oklahoma"
				41 ="41 Oregon"
				42 ="42 Pennsylvania"
				44 ="44 Rhode Island"
				45 ="45 South Carolina"
				46 ="46 South Dakota"
				47 ="47 Tennessee"
				48 ="48 Texas"
				49 ="49 Utah"
				50 ="50 Vermont"
				51 ="51 Virginia"
				53 ="53 Washington"
				54 ="54 West Virginia"
				55 ="55 Wisconsin"
				56 ="56 Wyoming";

 Value $Stabbr
  				"AL" ="AL Alabama"
				"AK" ="AK Alaska"
				"AZ" ="AZ Arizona"
				"AR" ="AR Arkansas"
				"CA" ="CA California"
				"CO" ="CO Colorado"
				"CT" ="CT Connecticut"
				"DE" ="DE Delaware"
				"DC" ="DC District of Columbia"
				"FL" ="FL Florida"
				"GA" ="GA Georgia"
				"HI" ="HI Hawaii"
				"ID" ="ID Idaho"
				"IL" ="IL Illinois"
				"IN" ="IN Indiana"
				"IA" ="IA Iowa"
				"KS" ="KS Kansas"
				"KY" ="KY Kentucky"
				"LA" ="LA Louisiana"
				"ME" ="ME Maine"
				"MD" ="MD Maryland"
				"MA" ="MA Massachusetts"
				"MI" ="MI Michigan"
				"MN" ="MN Minnesota"
				"MS" ="MS Mississippi"
				"MO" ="MO Missouri"
				"MT" ="MT Montana"
				"NE" ="NE Nebraska"
				"NV" ="NV Nevada"
				"NH" ="NH New Hampshire"
				"NJ" ="NJ New Jersey"
				"NM" ="NM New Mexico"
				"NY" ="NY New York"
				"NC" ="NC North Carolina"
				"ND" ="ND North Dakota"
				"OH" ="OH Ohio"
				"OK" ="OK Oklahoma"
				"OR" ="OR Oregon"
				"PA" ="PA Pennsylvania"
				"RI" ="RI Rhode Island"
				"SC" ="SC South Carolina"
				"SD" ="SD South Dakota"
				"TN" ="TN Tennessee"
				"TX" ="TX Texas"
				"UT" ="UT Utah"
				"VT" ="VT Vermont"
				"VA" ="VA Virginia"
				"WA" ="WA Washington"
				"WV" ="WV West Virginia"
				"WI" ="WI Wisconsin"
				"WY" ="WY Wyoming";

Value P415f  	1='Reg. Elementary or Secondary'
             	2='Montessori'
             	3='Special Program Emphasis'
             	4='Special Education'
             	5='Vocational/Technical'
				6='Early Childhood Program/Day Care Center'
             	7='Alternative';

Value Commtyf  	1='Central City'
               	2='Urban fringe or large town'
               	3='Rural or small town';

Value $Framef	'LIST'=	'School is part of list frame'
                'AREA'=	'School is part of area frame';

Value higradef       
				0 = 'Ungraded or less than 1st grade'
     			1 = '1st grade'
     			2 = '2nd grade'
     			3 = '3rd grade'
     			4 = '4th grade'
      			5 = '5th grade'
      			6 = '6th grade'     
      			7 = '7th grade'     
  			   	8 = '8th grade '
   			  	9 = '9th grade'
   			   10 = '10th grade'
   			   11 = '11th grade'
   			   12 = '12th grade'; 

Value Levelf 	1='Elementary'
             	2='Secondary'
             	3='Combined elementary and secondary';


Value $Localef 	'1'='Large central city'  
             	'2'='Mid-size central city'  
             	'3'='Urban fringe of large city' 
				'4'='Urban Fringe of mid-size city'  
				'5'='Large town'  
				'6'='Small town'  
				'7'='Rural';  

Value logradef  0 = 'Ungraded or less than 1st grade'
     			1 = '1st grade'
     			2 = '2nd grade'
     			3 = '3rd grade'
     			4 = '4th grade'
      			5 = '5th grade'
      			6 = '6th grade'     
      			7 = '7th grade'     
  			   	8 = '8th grade '
   			  	9 = '9th grade'
   			   10 = '10th grade'
   			   11 = '11th grade'
   			   12 = '12th grade' ;

Value Orientf  	1='Roman Catholic'
             	2='Amish'
             	3='Assembly of God'
             	4='Baptist'
             	5='Calvinist'
             	6='Christian (no specific denomination)'
             	7='Church of Christ'
            	8='Church of God'
            	9='Disciples of Christ'
            	10='Episcopal'
            	11='Friends'
            	12='Greek Orthodox'
            	13='Islamic'
            	14='Jewish'
            	15='Latter Day Saints'
            	16='Lutheran Church - Missouri Synod'
            	17='Evangelical Lutheran Church in America'
            	18='Wisconsin Evangelical Lutheran Synod'
            	19='Other Lutheran'
            	20='Mennonite'
            	21='Methodist'
            	22='Pentecostal'
            	23='Presbyterian'
            	24='Seventh-Day Adventist'
            	25='Other'
            	26='Nonsectarian, Exceptional children'
                27='Nonreligious, Montessori'
                28='Other nonsectarian';

Value Perminf 	1='None'
              	2='1-9 percent'
              	3='10-29 percent'
              	4='30-49 percent'
              	5='50 percent or more';

Value Regionf 	1='Northeast'
              	2='Midwest'
              	3='South'
              	4='West';

Value Religf 	1='Catholic'
             	2='Other religious'
             	3='Nonsectarian';

Value Sizef  	1='Less than 150 students'
             	2='150 to 299 students'
             	3='300 to 499 students'
             	4='500 to 749 students'
             	5='750 or more';

Value Tabflgf  	0='Included in tabulations'
             	1='Not included in tabulatons';

Value Typof   	1='Catholic, parochial'
 			 	2='Catholic, diocesan'
			 	3='Catholic, private'
			 	4='Other religious, conservative Christian'
			 	5='Other religious, affiliated'
			 	6='Other religious, not affiliated'
			 	7='Nonsectarian, regular school'
			 	8='Nonsectarian, special program'
			 	9='Nonsectarian, special education';

Value Imputf 	0='Not imputed  (original data)'
 			 	1='Ratio adjustment of original data'
			 	2='Imputed -- data from other variables'
			 	3='Imputed -- donor value from another record'
			 	4='Clerical imputation';
Run;

*******************************************************************;
*** The following lines of code have been commented out. If the ***;
*** user should wish to run file frequencies, or proc contents  ***;
*** they may submit these lines separtely or remove the "/*"    ***;
*** and "*/" characters before running this code. User may also ***;
*** wish to comment out the final school weight when running    ***;
*** frequency code.                                             ***;
*******************************************************************;

/*

*** Frequencies of Categorical Variables ***;

Proc Freq Data=OUT1.PSS9596_PU;
Table QSTABB QSTFIP P415 COMMTYPE FRAME LEVEL LOCALE ORIENT PERMINOR QHIGR6
QLOGR6 REGION RELIG SIZE TABFLAG1 TABFLAG2 TYPOLOGY
F_P135  F_P140  F_P145 F_P150  F_P155  F_P160  F_P165 F_P170  
F_P175  F_P180  F_P185 F_P190  F_P195  F_P200  F_P205 F_P210
F_P215  F_P220 F_P225  F_P230  F_P235  F_P240  F_P245
F_P250  F_P255  F_P260  F_P265 F_P270  F_P275  F_P280  F_P285
F_P290  F_P295  F_P300  F_P305 F_P310  F_P315  F_P320  F_P325
F_P330  F_P340  F_P345 F_P350  F_P355  F_P360  F_P365
F_P370  F_P375  F_P380  F_P385 F_P390  F_P395  F_P400  F_P405
F_P410  F_P415  F_P420  F_P425 F_P430  F_P435  F_P440  F_P445
F_P450  F_P455  F_P460  F_P465 F_P470  F_P475  F_P480  F_P485
F_P490  F_P495  F_P500  F_P505 F_P510  F_P515  F_P520  F_P525
F_P530  F_P535  F_P540  F_P545 F_P550  F_P555  F_P560  F_P565
F_P570  F_P575  F_P580  F_P585 F_P590  F_P595  F_P600  F_P605
F_P610  F_P615  F_P620  F_P625 F_P630  F_P635  F_P640  F_P645/Missing;
Format QSTABB $STABBR. QSTFIP FIPSF. P415 P415F. COMMTYPE COMMTYF.
FRAME $FRAMEF. QHIGR6 HIGRADEF. LEVEL LEVELF. LOCALE $LOCALEF.
QLOGR6 LOGRADEF. ORIENT ORIENTF. PERMINOR PERMINF. REGION REGIONF. RELIG RELIGF.
SIZE SIZEF. TABFLAG1 TABFLAG2 TABFLGF. TYPOLOGY TYPOF.
F_P135  F_P140  F_P145 F_P150  F_P155  F_P160  F_P165 F_P170  
F_P175  F_P180  F_P185 F_P190  F_P195  F_P200  F_P205 F_P210
F_P215  F_P220 F_P225  F_P230  F_P235  F_P240  F_P245
F_P250  F_P255  F_P260  F_P265 F_P270  F_P275  F_P280  F_P285
F_P290  F_P295  F_P300  F_P305 F_P310  F_P315  F_P320  F_P325
F_P330  F_P340  F_P345 F_P350  F_P355  F_P360  F_P365
F_P370  F_P375  F_P380  F_P385 F_P390  F_P395  F_P400  F_P405
F_P410  F_P415  F_P420  F_P425 F_P430  F_P435  F_P440  F_P445
F_P450  F_P455  F_P460  F_P465 F_P470  F_P475  F_P480  F_P485
F_P490  F_P495  F_P500  F_P505 F_P510  F_P515  F_P520  F_P525
F_P530  F_P535  F_P540  F_P545 F_P550  F_P555  F_P560  F_P565
F_P570  F_P575  F_P580  F_P585 F_P590  F_P595  F_P600  F_P605
F_P610  F_P615  F_P620  F_P625 F_P630  F_P635  F_P640  F_P645 IMPUTF.;
*WEIGHT QFNLWT;
Title 'Frequencies of Categorical Variables: PSS 1995-1996';
Run;

*** Data File Contents ***;

PROC CONTENTS DATA=OUT1.PSS9596_PU Varnum;
Title 'PRIVATE SCHOOL SURVEY, 1995-1996';
RUN;

*/

