**************************************************************************;
*** Created: July 16, 2006                                             ***;
*** Modify the LIBNAME path below to point to your data file           ***;
*** Written by: Kforce Government Solutions							   ***;
*** Program Name: Read_PSS_0304_PU.sas                                 ***;
***																	   ***;	
*** Data file Name: PSS0304_PU.TXT                                     ***;
*** The Tab-delimited file which is specified in the program must      ***;
*** be saved in the directory specified by INFILE statement            ***;
***                                                                    ***;
*** SAS code was written for SAS version 9.1 or above.  Labels were    ***;
*** given a maximun length of 60 characters. If you are using a SAS    ***;
*** version before SAS 8.0, you should be aware that labels could      ***;
*** be truncated to 40 characters.  If so the user may wish to         ***;
*** abreviate labels so that they are unique and are descriptive.      ***;
***                                                                    ***;
*** This program provides frequency for all categorical variables.     ***;
*** Users should uncomment the frequency section to generate frequency ***;
*** tables.                                                            ***;
***                                                                    ***;
*** There may be missing data for some institutions due to parent-     ***;
*** child relations.                                                   ***;
**************************************************************************;

LIBNAME OUT1 'C:\PUBLIC USE\PSS0304_CD_ROM';
      data OUT1.PSS0304_PU                             ;
      %let _EFIERR_ = 0; /* set the ERROR detection macro variable */
      infile 'C:\PUBLIC USE\PSS_DATA\PSS0304_PU.txt' delimiter='09'x MISSOVER DSD lrecl=32767
 firstobs=2 ;         
		 informat PPIN 			$8. ;
         informat PCITY 		$30. ;
         informat PSTABB 		$2. ;
         informat PSTFIP 		$2. ;
         informat PCNTY 		$3. ;
         informat PCNTNM 		$30. ;
         informat PZIP 			$10. ;
         informat SCHOOL 		8. ;
         informat P135 			8. ;
         informat P140 			8. ;
         informat P145 			8. ;
         informat P150 			8. ;
         informat P155 			8. ;
         informat P160 			8. ;
         informat P165 			8. ;
         informat P170 			8. ;
         informat P175 			8. ;
         informat P180 			8. ;
         informat S_KG 			8. ;
         informat P185 			8. ;
         informat P190 			8. ;
         informat P195 			8. ;
         informat P200 			8. ;
         informat P205 			8. ;
         informat P210 			8. ;
         informat P215 			8. ;
         informat P220 			8. ;
         informat P225 			8. ;
         informat P230 			8. ;
         informat P235 			8. ;
         informat P240 			8. ;
         informat P245 			8. ;
         informat P250 			8. ;
         informat P255 			8. ;
         informat P260 			8. ;
         informat P265 			8. ;
         informat P270 			8. ;
         informat P275 			8. ;
         informat P280 			8. ;
         informat P285 			8. ;
         informat P290 			8. ;
         informat P295 			8. ;
         informat P300 			8. ;
         informat P305 			8. ;
         informat P310 			8. ;
         informat P315 			8. ;
         informat P320 			8. ;
         informat P325 			8. ;
         informat P330 			8. ;
         informat P335 			8. ;
         informat P340 			8. ;
         informat P345 			8. ;
         informat P350 			8. ;
         informat P360 			8. ;
         informat P361 			8. ;
         informat P365 			8. ;
         informat P370 			8. ;
         informat P385 			8. ;
         informat P390 			8. ;
         informat P395 			8. ;
         informat P400 			8. ;
         informat P405 			8. ;
         informat P410 			8. ;
         informat P415 			8. ;
         informat P420 			8. ;
         informat P425 			8. ;
         informat P430 			8. ;
         informat P435 			8. ;
         informat P440 			8. ;
         informat P445 			8. ;
         informat P450 			8. ;
         informat P455 			8. ;
         informat P460 			8. ;
         informat P465 			8. ;
         informat P467 			8. ;
         informat P470 			8. ;
         informat P475 			8. ;
         informat P480 			8. ;
         informat P485 			8. ;
         informat P490 			8. ;
         informat P492 			8. ;
         informat P495 			8. ;
         informat P500 			8. ;
         informat P505 			8. ;
         informat P510 			8. ;
         informat P515 			8. ;
         informat P520 			8. ;
         informat P525 			8. ;
         informat P530 			8. ;
         informat P535 			8. ;
         informat P540 			8. ;
         informat P545 			8. ;
         informat P550 			8. ;
         informat P555 			8. ;
         informat P560 			8. ;
         informat P565 			8. ;
         informat P570 			8. ;
         informat P575 			8. ;
         informat P580 			8. ;
         informat P585 			8. ;
         informat P590 			8. ;
         informat P595 			8. ;
         informat P600 			8. ;
         informat P602 			8. ;
         informat P605 			8. ;
         informat P610 			8. ;
         informat P615 			8. ;
         informat P620 			8. ;
         informat P622 			8. ;
         informat P625 			8. ;
         informat P630 			8. ;
         informat P635 			8. ;
         informat P640 			8. ;
         informat P645 			8. ;
         informat P650 			8. ;
         informat P655 			8. ;
         informat P660 			8. ;
         informat P665 			8. ;
         informat COMMTYP2 		8. ;
         informat COMMTYPE 		8. ;
         informat DIOCESE  		8. ;
         informat FRAME 		$4. ;
         informat HIGR2004 		8. ;
         informat LEVEL 		8. ;
         informat LOCALE 		8. ;
         informat ULOCALE 		8. ;
         informat LOGR2004 		8. ;
         informat MALES 		8. ;
         informat MINOR 		8. ;
         informat NUMSTUDS 		8. ;
         informat NUMTEACH 		5.1 ;
         informat ORIENT 		8. ;
         informat P_INDIAN 		14.10 ;
         informat P_ASIAN 		14.10 ;
         informat P_HISP 		14.10 ;
         informat P_BLACK 		14.10 ;
         informat P_WHITE 		14.10 ;
         informat PERMINOR 		8. ;
         informat PMINOR 		14.10 ;
         informat REGION 		8. ;
         informat RELIG 		8. ;
         informat SIZE 			8. ;
         informat STTCH_RT 		15.10;
         informat TABFLAG 		8.;
         informat TOTHRS 		13.10;
         informat TYPOLOGY 		8.;
         informat PFNLWT 		13.10;
         informat REPW1 		14.10;
         informat REPW2 		14.10 ;
         informat REPW3 		14.10 ;
         informat REPW4 		14.10 ;
         informat REPW5 		14.10 ;
         informat REPW6 		14.10 ;
         informat REPW7 		14.10 ;
         informat REPW8 		14.10 ;
         informat REPW9 		14.10 ;
         informat REPW10 		14.10 ;
         informat REPW11 		14.10 ;
         informat REPW12 		14.10 ;
         informat REPW13 		14.10 ;
         informat REPW14 		14.10 ;
         informat REPW15 		14.10 ;
         informat REPW16 		14.10 ;
         informat REPW17 		14.10 ;
         informat REPW18 		14.10 ;
         informat REPW19 		14.10 ;
         informat REPW20  		14.10 ;
         informat REPW21 		14.10 ;
         informat REPW22 		14.10 ;
         informat REPW23 		14.10 ;
         informat REPW24 		14.10 ;
         informat REPW25 		14.10 ;
         informat REPW26 		14.10 ;
         informat REPW27 		14.10 ;
         informat REPW28 		14.10 ;
         informat REPW29 		14.10 ;
         informat REPW30  		14.10 ;
         informat REPW31 		14.10 ;
         informat REPW32 		14.10 ;
         informat REPW33 		14.10 ;
         informat REPW34 		14.10 ;
         informat REPW35 		14.10 ;
         informat REPW36 		14.10 ;
         informat REPW37 		14.10 ;
         informat REPW38 		14.10 ;
         informat REPW39 		14.10 ;
         informat REPW40  		14.10 ;
         informat REPW41 		14.10 ;
         informat REPW42 		14.10 ;
         informat REPW43 		14.10 ;
         informat REPW44 		14.10 ;
         informat REPW45 		14.10 ;
         informat REPW46 		14.10 ;
         informat REPW47 		14.10 ;
         informat REPW48 		14.10 ;
         informat REPW49 		14.10 ;
         informat REPW50  		14.10 ;
         informat REPW51 		14.10 ;
         informat REPW52 		14.10 ;
         informat REPW53 		14.10 ;
         informat REPW54 		14.10 ;
         informat REPW55 		14.10 ;
         informat REPW56 		14.10 ;
         informat REPW57 		14.10 ;
         informat REPW58 		14.10 ;
         informat REPW59 		14.10 ;
         informat REPW60  		14.10 ;
         informat REPW61 		14.10 ;
         informat REPW62 		14.10 ;
         informat REPW63 		14.10 ;
         informat REPW64 		14.10 ;
         informat REPW65 		14.10 ;
         informat REPW66 		14.10 ;
         informat REPW67 		14.10 ;
         informat REPW68 		14.10 ;
         informat REPW69 		14.10 ;
         informat REPW70  		14.10 ;
         informat REPW71 		14.10 ;
         informat REPW72 		14.10 ;
         informat REPW73 		14.10 ;
         informat REPW74 		14.10 ;
         informat REPW75 		14.10 ;
         informat REPW76 		14.10 ;
         informat REPW77 		14.10 ;
         informat REPW78 		14.10 ;
         informat REPW79 		14.10 ;
         informat REPW80  		14.10 ;
         informat REPW81 		14.10 ;
         informat REPW82 		14.10 ;
         informat REPW83 		14.10 ;
         informat REPW84 		14.10 ;
         informat REPW85 		14.10 ;
         informat REPW86 		14.10 ;
         informat REPW87 		14.10 ;
         informat REPW88 		14.10 ;
         informat F_P135 		8. ;
         informat F_P140  		8. ;
         informat F_P145 		8. ;
         informat F_P150 		8. ;
         informat F_P155 		8. ;
         informat F_P160 		8. ;
         informat F_P165 		8. ;
         informat F_P170 		8. ;
         informat F_P175 		8. ;
         informat F_P180 		8. ;
         informat F_P185 		8. ;
         informat F_P190  		8. ;
         informat F_P195 		8. ;
         informat F_P200 		8. ;
         informat F_P205 		8. ;
         informat F_P210 		8. ;
         informat F_P215 		8. ;
         informat F_P220 		8. ;
         informat F_P225 		8. ;
         informat F_P230 		8. ;
         informat F_P235 		8. ;
         informat F_P240  		8. ;
         informat F_P245 		8. ;
         informat F_P250 		8. ;
         informat F_P255 		8. ;
         informat F_P260 		8. ;
         informat F_P265 		8. ;
         informat F_P270 		8. ;
         informat F_P275 		8. ;
         informat F_P280 		8. ;
         informat F_P285 		8. ;
         informat F_P290  		8. ;
         informat F_P295 		8. ;
         informat F_P300 		8. ;
         informat F_P305 		8. ;
         informat F_P310 		8. ;
         informat F_P315 		8. ;
         informat F_P320 		8. ;
         informat F_P325 		8. ;
         informat F_P330 		8. ;
         informat F_P335 		8. ;
         informat F_P340  		8. ;
         informat F_P345 		8. ;
         informat F_P350 		8. ;
         informat F_P360 		8. ;
         informat F_P361 		8. ;
         informat F_P365 		8. ;
         informat F_P370 		8. ;
         informat F_P385 		8. ;
         informat F_P390 		8. ;
         informat F_P395 		8. ;
         informat F_P400  		8. ;
         informat F_P405 		8. ;
         informat F_P410 		8. ;
         informat F_P415 		8. ;
         informat F_P420 		8. ;
         informat F_P425 		8. ;
         informat F_P430 		8. ;
         informat F_P435 		8. ;
         informat F_P440 		8. ;
         informat F_P445 		8. ;
         informat F_P450  		8. ;
         informat F_P455 		8. ;
         informat F_P460 		8. ;
         informat F_P465 		8. ;
         informat F_P467 		8. ;
         informat F_P470 		8. ;
         informat F_P475 		8. ;
         informat F_P480 		8. ;
         informat F_P485 		8. ;
         informat F_P490 		8. ;
         informat F_P492  		8. ;
         informat F_P495 		8. ;
         informat F_P500 		8. ;
         informat F_P505 		8. ;
         informat F_P510 		8. ;
         informat F_P515 		8. ;
         informat F_P520 		8. ;
         informat F_P525 		8. ;
         informat F_P530 		8. ;
         informat F_P535 		8. ;
         informat F_P540  		8. ;
         informat F_P545 		8. ;
         informat F_P550 		8. ;
         informat F_P555 		8. ;
         informat F_P560 		8. ;
         informat F_P565 		8. ;
         informat F_P570 		8. ;
         informat F_P575 		8. ;
         informat F_P580 		8. ;
         informat F_P585 		8. ;
         informat F_P590  		8. ;
         informat F_P595 		8. ;
         informat F_P600 		8. ;
         informat F_P602 		8. ;
         informat F_P605 		8. ;
         informat F_P610 		8. ;
         informat F_P615 		8. ;
         informat F_P620 		8. ;
         informat F_P622 		8. ;
         informat F_P625 		8. ;
         informat F_P630  		8. ;
         informat F_P635 		8. ;
         informat F_P640 		8. ;
         informat F_P645 		8. ;
         informat F_P650 		8. ;
         informat F_P655 		8. ;
         informat F_P660 		8. ;

		 format PPIN 			$8. ;
         format PCITY 		$30. ;
         format PSTABB 		$2. ;
         format PSTFIP 		$2. ;
         format PCNTY 		$3. ;
         format PCNTNM 		$30. ;
         format PZIP 			$10. ;
         format SCHOOL 		8. ;
         format P135 			8. ;
         format P140 			8. ;
         format P145 			8. ;
         format P150 			8. ;
         format P155 			8. ;
         format P160 			8. ;
         format P165 			8. ;
         format P170 			8. ;
         format P175 			8. ;
         format P180 			8. ;
         format S_KG 			8. ;
         format P185 			8. ;
         format P190 			8. ;
         format P195 			8. ;
         format P200 			8. ;
         format P205 			8. ;
         format P210 			8. ;
         format P215 			8. ;
         format P220 			8. ;
         format P225 			8. ;
         format P230 			8. ;
         format P235 			8. ;
         format P240 			8. ;
         format P245 			8. ;
         format P250 			8. ;
         format P255 			8. ;
         format P260 			8. ;
         format P265 			8. ;
         format P270 			8. ;
         format P275 			8. ;
         format P280 			8. ;
         format P285 			8. ;
         format P290 			8. ;
         format P295 			8. ;
         format P300 			8. ;
         format P305 			8. ;
         format P310 			8. ;
         format P315 			8. ;
         format P320 			8. ;
         format P325 			8. ;
         format P330 			8. ;
         format P335 			8. ;
         format P340 			8. ;
         format P345 			8. ;
         format P350 			8. ;
         format P360 			8. ;
         format P361 			8. ;
         format P365 			8. ;
         format P370 			8. ;
         format P385 			8. ;
         format P390 			8. ;
         format P395 			8. ;
         format P400 			8. ;
         format P405 			8. ;
         format P410 			8. ;
         format P415 			8. ;
         format P420 			8. ;
         format P425 			8. ;
         format P430 			8. ;
         format P435 			8. ;
         format P440 			8. ;
         format P445 			8. ;
         format P450 			8. ;
         format P455 			8. ;
         format P460 			8. ;
         format P465 			8. ;
         format P467 			8. ;
         format P470 			8. ;
         format P475 			8. ;
         format P480 			8. ;
         format P485 			8. ;
         format P490 			8. ;
         format P492 			8. ;
         format P495 			8. ;
         format P500 			8. ;
         format P505 			8. ;
         format P510 			8. ;
         format P515 			8. ;
         format P520 			8. ;
         format P525 			8. ;
         format P530 			8. ;
         format P535 			8. ;
         format P540 			8. ;
         format P545 			8. ;
         format P550 			8. ;
         format P555 			8. ;
         format P560 			8. ;
         format P565 			8. ;
         format P570 			8. ;
         format P575 			8. ;
         format P580 			8. ;
         format P585 			8. ;
         format P590 			8. ;
         format P595 			8. ;
         format P600 			8. ;
         format P602 			8. ;
         format P605 			8. ;
         format P610 			8. ;
         format P615 			8. ;
         format P620 			8. ;
         format P622 			8. ;
         format P625 			8. ;
         format P630 			8. ;
         format P635 			8. ;
         format P640 			8. ;
         format P645 			8. ;
         format P650 			8. ;
         format P655 			8. ;
         format P660 			8. ;
         format P665 			8. ;
         format COMMTYP2 		8. ;
         format COMMTYPE 		8. ;
         format DIOCESE  		8. ;
         format FRAME 		$4. ;
         format HIGR2004 		8. ;
         format LEVEL 		8. ;
         format LOCALE 		8. ;
         format ULOCALE 		8. ;
         format LOGR2004 		8. ;
         format MALES 		8. ;
         format MINOR 		8. ;
         format NUMSTUDS 		8. ;
         format NUMTEACH 		5.1 ;
         format ORIENT 		8. ;
         format P_INDIAN 		14.10 ;
         format P_ASIAN 		14.10 ;
         format P_HISP 		14.10 ;
         format P_BLACK 		14.10 ;
         format P_WHITE 		14.10 ;
         format PERMINOR 		8. ;
         format PMINOR 		14.10 ;
         format REGION 		8. ;
         format RELIG 		8. ;
         format SIZE 			8. ;
         format STTCH_RT 		15.10;
         format TABFLAG 		8.;
         format TOTHRS 		13.10;
         format TYPOLOGY 		8.;
         format PFNLWT 		13.10;
         format REPW1 		14.10;
         format REPW2 		14.10 ;
         format REPW3 		14.10 ;
         format REPW4 		14.10 ;
         format REPW5 		14.10 ;
         format REPW6 		14.10 ;
         format REPW7 		14.10 ;
         format REPW8 		14.10 ;
         format REPW9 		14.10 ;
         format REPW10 		14.10 ;
         format REPW11 		14.10 ;
         format REPW12 		14.10 ;
         format REPW13 		14.10 ;
         format REPW14 		14.10 ;
         format REPW15 		14.10 ;
         format REPW16 		14.10 ;
         format REPW17 		14.10 ;
         format REPW18 		14.10 ;
         format REPW19 		14.10 ;
         format REPW20  		14.10 ;
         format REPW21 		14.10 ;
         format REPW22 		14.10 ;
         format REPW23 		14.10 ;
         format REPW24 		14.10 ;
         format REPW25 		14.10 ;
         format REPW26 		14.10 ;
         format REPW27 		14.10 ;
         format REPW28 		14.10 ;
         format REPW29 		14.10 ;
         format REPW30  		14.10 ;
         format REPW31 		14.10 ;
         format REPW32 		14.10 ;
         format REPW33 		14.10 ;
         format REPW34 		14.10 ;
         format REPW35 		14.10 ;
         format REPW36 		14.10 ;
         format REPW37 		14.10 ;
         format REPW38 		14.10 ;
         format REPW39 		14.10 ;
         format REPW40  		14.10 ;
         format REPW41 		14.10 ;
         format REPW42 		14.10 ;
         format REPW43 		14.10 ;
         format REPW44 		14.10 ;
         format REPW45 		14.10 ;
         format REPW46 		14.10 ;
         format REPW47 		14.10 ;
         format REPW48 		14.10 ;
         format REPW49 		14.10 ;
         format REPW50  		14.10 ;
         format REPW51 		14.10 ;
         format REPW52 		14.10 ;
         format REPW53 		14.10 ;
         format REPW54 		14.10 ;
         format REPW55 		14.10 ;
         format REPW56 		14.10 ;
         format REPW57 		14.10 ;
         format REPW58 		14.10 ;
         format REPW59 		14.10 ;
         format REPW60  		14.10 ;
         format REPW61 		14.10 ;
         format REPW62 		14.10 ;
         format REPW63 		14.10 ;
         format REPW64 		14.10 ;
         format REPW65 		14.10 ;
         format REPW66 		14.10 ;
         format REPW67 		14.10 ;
         format REPW68 		14.10 ;
         format REPW69 		14.10 ;
         format REPW70  		14.10 ;
         format REPW71 		14.10 ;
         format REPW72 		14.10 ;
         format REPW73 		14.10 ;
         format REPW74 		14.10 ;
         format REPW75 		14.10 ;
         format REPW76 		14.10 ;
         format REPW77 		14.10 ;
         format REPW78 		14.10 ;
         format REPW79 		14.10 ;
         format REPW80  		14.10 ;
         format REPW81 		14.10 ;
         format REPW82 		14.10 ;
         format REPW83 		14.10 ;
         format REPW84 		14.10 ;
         format REPW85 		14.10 ;
         format REPW86 		14.10 ;
         format REPW87 		14.10 ;
         format REPW88 		14.10 ;
         format F_P135 		8. ;
         format F_P140  		8. ;
         format F_P145 		8. ;
         format F_P150 		8. ;
         format F_P155 		8. ;
         format F_P160 		8. ;
         format F_P165 		8. ;
         format F_P170 		8. ;
         format F_P175 		8. ;
         format F_P180 		8. ;
         format F_P185 		8. ;
         format F_P190  		8. ;
         format F_P195 		8. ;
         format F_P200 		8. ;
         format F_P205 		8. ;
         format F_P210 		8. ;
         format F_P215 		8. ;
         format F_P220 		8. ;
         format F_P225 		8. ;
         format F_P230 		8. ;
         format F_P235 		8. ;
         format F_P240  		8. ;
         format F_P245 		8. ;
         format F_P250 		8. ;
         format F_P255 		8. ;
         format F_P260 		8. ;
         format F_P265 		8. ;
         format F_P270 		8. ;
         format F_P275 		8. ;
         format F_P280 		8. ;
         format F_P285 		8. ;
         format F_P290  		8. ;
         format F_P295 		8. ;
         format F_P300 		8. ;
         format F_P305 		8. ;
         format F_P310 		8. ;
         format F_P315 		8. ;
         format F_P320 		8. ;
         format F_P325 		8. ;
         format F_P330 		8. ;
         format F_P335 		8. ;
         format F_P340  		8. ;
         format F_P345 		8. ;
         format F_P350 		8. ;
         format F_P360 		8. ;
         format F_P361 		8. ;
         format F_P365 		8. ;
         format F_P370 		8. ;
         format F_P385 		8. ;
         format F_P390 		8. ;
         format F_P395 		8. ;
         format F_P400  		8. ;
         format F_P405 		8. ;
         format F_P410 		8. ;
         format F_P415 		8. ;
         format F_P420 		8. ;
         format F_P425 		8. ;
         format F_P430 		8. ;
         format F_P435 		8. ;
         format F_P440 		8. ;
         format F_P445 		8. ;
         format F_P450  		8. ;
         format F_P455 		8. ;
         format F_P460 		8. ;
         format F_P465 		8. ;
         format F_P467 		8. ;
         format F_P470 		8. ;
         format F_P475 		8. ;
         format F_P480 		8. ;
         format F_P485 		8. ;
         format F_P490 		8. ;
         format F_P492  		8. ;
         format F_P495 		8. ;
         format F_P500 		8. ;
         format F_P505 		8. ;
         format F_P510 		8. ;
         format F_P515 		8. ;
         format F_P520 		8. ;
         format F_P525 		8. ;
         format F_P530 		8. ;
         format F_P535 		8. ;
         format F_P540  		8. ;
         format F_P545 		8. ;
         format F_P550 		8. ;
         format F_P555 		8. ;
         format F_P560 		8. ;
         format F_P565 		8. ;
         format F_P570 		8. ;
         format F_P575 		8. ;
         format F_P580 		8. ;
         format F_P585 		8. ;
         format F_P590  		8. ;
         format F_P595 		8. ;
         format F_P600 		8. ;
         format F_P602 		8. ;
         format F_P605 		8. ;
         format F_P610 		8. ;
         format F_P615 		8. ;
         format F_P620 		8. ;
         format F_P622 		8. ;
         format F_P625 		8. ;
         format F_P630  		8. ;
         format F_P635 		8. ;
         format F_P640 		8. ;
         format F_P645 		8. ;
         format F_P650 		8. ;
         format F_P655 		8. ;
         format F_P660 		8. ;
      input
                  PPIN  $
                  PCITY $
                  PSTABB $
                  PSTFIP $
                  PCNTY $
                  PCNTNM $
                  PZIP $
                  SCHOOL
                  P135
                  P140 $
                  P145
                  P150
                  P155
                  P160
                  P165
                  P170
                  P175
                  P180 $
                  S_KG
                  P185
                  P190
                  P195
                  P200
                  P205
                  P210
                  P215
                  P220
                  P225
                  P230
                  P235
                  P240
                  P245
                  P250
                  P255
                  P260
                  P265
                  P270
                  P275
                  P280
                  P285
                  P290
                  P295
                  P300
                  P305
                  P310
                  P315
                  P320
                  P325
                  P330
                  P335
                  P340
                  P345
                  P350
                  P360
                  P361
                  P365
                  P370
                  P385
                  P390
                  P395
                  P400
                  P405
                  P410
                  P415
                  P420
                  P425
                  P430
                  P435
                  P440
                  P445
                  P450
                  P455
                  P460
                  P465
                  P467
                  P470
                  P475
                  P480
                  P485
                  P490
                  P492
                  P495
                  P500
                  P505
                  P510
                  P515
                  P520
                  P525
                  P530
                  P535
                  P540
                  P545
                  P550
                  P555
                  P560
                  P565
                  P570
                  P575
                  P580
                  P585
                  P590
                  P595
                  P600
                  P602
                  P605
                  P610
                  P615
                  P620
                  P622
                  P625
                  P630
                  P635
                  P640
                  P645
                  P650
                  P655
                  P660
                  P665
                  COMMTYP2
                  COMMTYPE
                  DIOCESE
                  FRAME $
                  HIGR2004
                  LEVEL
                  LOCALE
                  ULOCALE
                  LOGR2004
                  MALES
                  MINOR
                  NUMSTUDS
                  NUMTEACH
                  ORIENT
                  P_INDIAN
                  P_ASIAN
                  P_HISP
                  P_BLACK
                  P_WHITE
                  PERMINOR
                  PMINOR
                  REGION
                  RELIG
                  SIZE
                  STTCH_RT
                  TABFLAG
                  TOTHRS
                  TYPOLOGY
                  PFNLWT
                  REPW1
                  REPW2
                  REPW3
                  REPW4
                  REPW5
                  REPW6
                  REPW7
                  REPW8
                  REPW9
                  REPW10
                  REPW11
                  REPW12
                  REPW13
                  REPW14
                  REPW15
                  REPW16
                  REPW17
                  REPW18
                  REPW19
                  REPW20
                  REPW21
                  REPW22
                  REPW23
                  REPW24
                  REPW25
                  REPW26
                  REPW27
                  REPW28
                  REPW29
                  REPW30
                  REPW31
                  REPW32
                  REPW33
                  REPW34
                  REPW35
                  REPW36
                  REPW37
                  REPW38
                  REPW39
                  REPW40
                  REPW41
                  REPW42
                  REPW43
                  REPW44
                  REPW45
                  REPW46
                  REPW47
                  REPW48
                  REPW49
                  REPW50
                  REPW51
                  REPW52
                  REPW53
                  REPW54
                  REPW55
                  REPW56
                  REPW57
                  REPW58
                  REPW59
                  REPW60
                  REPW61
                  REPW62
                  REPW63
                  REPW64
                  REPW65
                  REPW66
                  REPW67
                  REPW68
                  REPW69
                  REPW70
                  REPW71
                  REPW72
                  REPW73
                  REPW74
                  REPW75
                  REPW76
                  REPW77
                  REPW78
                  REPW79
                  REPW80
                  REPW81
                  REPW82
                  REPW83
                  REPW84
                  REPW85
                  REPW86
                  REPW87
                  REPW88
                  F_P135
                  F_P140
                  F_P145
                  F_P150
                  F_P155
                  F_P160
                  F_P165
                  F_P170
                  F_P175
                  F_P180
                  F_P185
                  F_P190
                  F_P195
                  F_P200
                  F_P205
                  F_P210
                  F_P215
                  F_P220
                  F_P225
                  F_P230
                  F_P235
                  F_P240
                  F_P245
                  F_P250
                  F_P255
                  F_P260
                  F_P265
                  F_P270
                  F_P275
                  F_P280
                  F_P285
                  F_P290
                  F_P295
                  F_P300
                  F_P305
                  F_P310
                  F_P315
                  F_P320
                  F_P325
                  F_P330
                  F_P335
                  F_P340
                  F_P345
                  F_P350
                  F_P360
                  F_P361
                  F_P365
                  F_P370
                  F_P385
                  F_P390
                  F_P395
                  F_P400
                  F_P405
                  F_P410
                  F_P415
                  F_P420
                  F_P425
                  F_P430
                  F_P435
                  F_P440
                  F_P445
                  F_P450
                  F_P455
                  F_P460
                  F_P465
                  F_P467
                  F_P470
                  F_P475
                  F_P480
                  F_P485
                  F_P490
                  F_P492
                  F_P495
                  F_P500
                  F_P505
                  F_P510
                  F_P515
                  F_P520
                  F_P525
                  F_P530
                  F_P535
                  F_P540
                  F_P545
                  F_P550
                  F_P555
                  F_P560
                  F_P565
                  F_P570
                  F_P575
                  F_P580
                  F_P585
                  F_P590
                  F_P595
                  F_P600
                  F_P602
                  F_P605
                  F_P610
                  F_P615
                  F_P620
                  F_P622
                  F_P625
                  F_P630
                  F_P635
                  F_P640
                  F_P645
                  F_P650
                  F_P655
                  F_P660
      ;
label 
	
PPIN	= 'Permanent Identification Number'
PCITY	= 'City of Mailing Address'
PSTABB	= 'State Postal Code of Mailing Address'
PSTFIP	= 'Fips State Code'
PCNTY	= 'Fips County Code'
PCNTNM	= 'County Name'
PZIP	= 'Zip Code of Mailing Address (Zip + 4)'
SCHOOL	= 'School Counter'
P135	= '5A Ungraded Offered'
P140	= '5A Ungraded Enrollment'
P145	= '5B Nursery/Prekindergarten Offered'
P150	= '5B Nursery/Prekindergarten Enrollment'
P155	= '5C Kindergarten Offered'
P160	= '5C Kindergarten Enrollment'
P165	= '5D Transitional Kindergarten Offered'
P170	= '5D Transitional Kindergarten Enrollment'
P175	= '5E Transitional First Grade Offered'
P180	= '5E Transitional First Grade Enrollment'
S_KG	= 'Total Kindergarten Enrollment'
P185	= '5F First Grade Offered'
P190	= '5F First Grade Enrollment'
P195	= '5G Second Grade Offered'
P200	= '5G Second Grade Enrollment'
P205	= '5H Third Grade Offered'
P210	= '5H Third Grade Enrollment'
P215	= '5I Fourth Grade Offered'
P220	= '5I Fourth Grade Enrollment'
P225	= '5J Fifth Grade Offered'
P230	= '5J Fifth Grade Enrollment'
P235	= '5K Sixth Grade Offered'
P240	= '5K Sixth Grade Enrollment'
P245	= '5L Seventh Grade Offered'
P250	= '5L Seventh Grade Enrollment'
P255	= '5M Eighth Grade Offered'
P260	= '5M Eighth Grade Enrollment'
P265	= '5N Ninth Grade Offered'
P270	= '5N Ninth Grade Enrollment'
P275	= '5O Tenth Grade Offered'
P280	= '5O Tenth Grade Enrollment'
P285	= '5P Eleventh Grade Offered'
P290	= '5P Eleventh Grade Enrollment'
P295	= '5Q Twelfth Grade Offered'
P300	= '5Q Twelfth Grade Enrollment'
P305	= '6 Total Student Enrollment'
P310	= '7E Am Indian/Alaska Native Students'
P315	= '7D Asian Or Pacific Islander Students'
P320	= '7A Hispanic Students'
P325	= '7C Black Students'
P330	= '7B White Students'
P335	= '8A Is School Coeducational'
P340	= '8B Number of Male Students'
P345	= '9A Students in 12th Grade Last Year'
P350	= '9B How Many In 12Th Grade Last Year'
P360	= '9D Percent To 4 Year College'
P361	= '9D Percent To 2 Year College'
P365	= '10A Half Day Or Full Day'
P370	= '10B Days Per Week'
P385	= '11 Full-Time Teachers'
P390	= '11 More Than 3/4 Time Teachers'
P395	= '11 More Than 1/2 Time Teachers'
P400	= '11 More Than 1/4 Time Teachers'
P405	= '11 Less Than 1/4 Time Teachers'
P410	= '11 Total Number Of Teachers'
P415	= '12A Type of School'
P420	= '12B School Support Home Schooling'
P425	= '13 Is School Located In Private Home'
P430	= '14A Does School Have Relig Orientation'
P435	= '14B School Affiliated W/Religious'
P440	= '14C Religious Orientation/Affiliation'
P445	= '14C What Type of Catholic School'
P450	= '15 No Associations'
P455	= '15 Accelerated Christian Education'
P460	= '15 American Assn of Christian Schools'
P465	= '15 Assn of Christian Schools Internatl'
P467	= '15 Assn of Christian Teachers And Schools'
P470	= '15 Christian Schools International'
P475	= '15 Council Islamic Schls In N. America'
P480	= '15 Evangelical Lutheran Education Assn'
P485	= '15 Friends Council on Education'
P490	= '15 Gen Conference of Sda Church'
P492	= '15 Islamic School League of America'
P495	= '15 Jesuit Secondary Education Assn'
P500	= '15 National Assn of Episcopal Schools'
P505	= '15 National Catholic Educational Assn'
P510	= '15 National Christian School Assn'
P515	= '15 Natl Society of Hebrew Day Schools'
P520	= '15 oral Roberts Univ Edu Fellowship'
P525	= '15 Solomon Schechter Day Schools'
P530	= '15 So Baptist Assn of Christian Schools'
P535	= '15 other Religious School Associations'
P540	= '15 American Montessori Society'
P545	= '15 other Montessori Associations'
P550	= '15 Assn Military Colleges And Schools'
P555	= '15 Assn Waldorf Schools of N. America'
P560	= '15 Bilingual School Association'
P565	= '15 Council of Bilingual Education'
P570	= '15 Council For Exceptional Children'
P575	= '15 Natl Assn of Private Schls/Ex Child'
P580	= '15 other Assns For Exceptional Children'
P585	= '15 European Council For Intnatl School'
P590	= '15 Natl Assn For The Ed of Young Child'
P595	= '15 Natl Assn of Bilingual Education'
P600	= '15 National Assn of Laboratory Schools'
P602	= '15 National Coalition of Girls Schools'
P605	= '15 other Special Emphasis Associations'
P610	= '15 Alternative School Network'
P615	= '15 Institute For Independent Education'
P620	= '15 National Assn of Independent Schools'
P622	= '15 State or Regional Independent School'
P625	= '15 Natl Coalition of Alt Community Sch'
P630	= '15 Natl Independent Private School Assn'
P635	= '15 Assn of Boarding Schools'
P640	= '15 other School Associations'
P645	= '16 Days In School Year'
P650	= '17 Hours In School Day For Students'
P655	= '17 Minutes In School Day For Students'
P660	= '18 Library'
P665	= '19 Minutes To Complete Questionnaire'
COMMTYP2 ='Community Type Recode'
COMMTYPE ='Community Type'
DIOCESE	= 'Diocese or Archdiocese - Catholic Schls'
FRAME	= 'Universe Frame To Which School Belongs'
HIGR2004 = '2003-2004 Highest Grade Level Recode'
LEVEL	= 'Level of Instruction'
LOCALE	= 'New Urbanicity Defined (Census Assigned)'
ULOCALE	= 'Urban-centric locale code'
LOGR2004 = '2003-2004 Lowest Grade Level Recode'
MALES =	'Number of Male Students'
MINOR = 'Total Minority Students'
NUMSTUDS =	'Total No. of Students In Schl (K-12, Ug)'
NUMTEACH =	'Total No. of Full-Time Equiv. Tchrs Ftes'
ORIENT = 'School Orientation'
P_INDIAN =	'Percent Am Indian/Alaskan Native Stdts'
P_ASIAN	= 'Percent Asian or Pacific Islander Stdts'
P_HISP	= 'Percent Hispanic Students'
P_BLACK	= 'Percent Black Students'
P_WHITE	= 'Percent White Students'
PERMINOR =	'Percent Minority Students (Recode)'
PMINOR = 'Percent Minority Students'
REGION = 'Census Region'
RELIG =	'School Affiliation'
SIZE =	'Size of School (Enrollment Recode)'
STTCH_RT =	'Student/Teacher Ratio'
TABFLAG	= 'Tabulation Flag'
TOTHRS = 'Length of School Day In Hours'
TYPOLOGY =	'School Typology'
PFNLWT = 'Final Weight For School'
REPW1 	= 'Replicate Weight 1'
REPW2	= 'Replicate Weight 2'
REPW3	= 'Replicate Weight 3'
REPW4	= 'Replicate Weight 4'
REPW5	= 'Replicate Weight 5'
REPW6	= 'Replicate Weight 6'
REPW7	= 'Replicate Weight 7'
REPW8	= 'Replicate Weight 8'
REPW9	= 'Replicate Weight 9'
REPW10	= 'Replicate Weight 10'
REPW11	= 'Replicate Weight 11'
REPW12	= 'Replicate Weight 12'
REPW13	= 'Replicate Weight 13'
REPW14	= 'Replicate Weight 14'
REPW15	= 'Replicate Weight 15'
REPW16	= 'Replicate Weight 16'
REPW17	= 'Replicate Weight 17'
REPW18	= 'Replicate Weight 18'
REPW19	= 'Replicate Weight 19'
REPW20	= 'Replicate Weight 20'
REPW21	= 'Replicate Weight 21'
REPW22	= 'Replicate Weight 22'
REPW23	= 'Replicate Weight 23'
REPW24	= 'Replicate Weight 24'
REPW25	= 'Replicate Weight 25'
REPW26	= 'Replicate Weight 26'
REPW27	= 'Replicate Weight 27'
REPW28	= 'Replicate Weight 28'
REPW29	= 'Replicate Weight 29'
REPW30	= 'Replicate Weight 30'
REPW31	= 'Replicate Weight 31'
REPW32	= 'Replicate Weight 32'
REPW33	= 'Replicate Weight 33'
REPW34	= 'Replicate Weight 34'
REPW35	= 'Replicate Weight 35'
REPW36	= 'Replicate Weight 36'
REPW37	= 'Replicate Weight 37'
REPW38	= 'Replicate Weight 38'
REPW39	= 'Replicate Weight 39'
REPW40	= 'Replicate Weight 40'
REPW41	= 'Replicate Weight 41'
REPW42	= 'Replicate Weight 42'
REPW43	= 'Replicate Weight 43'
REPW44	= 'Replicate Weight 44'
REPW45	= 'Replicate Weight 45'
REPW46	= 'Replicate Weight 46'
REPW47	= 'Replicate Weight 47'
REPW48	= 'Replicate Weight 48'
REPW49	= 'Replicate Weight 49'
REPW50	= 'Replicate Weight 50'
REPW51	= 'Replicate Weight 51'
REPW52	= 'Replicate Weight 52'
REPW53	= 'Replicate Weight 53'
REPW54	= 'Replicate Weight 54'
REPW55	= 'Replicate Weight 55'
REPW56	= 'Replicate Weight 56'
REPW57	= 'Replicate Weight 57'
REPW58	= 'Replicate Weight 58'
REPW59	= 'Replicate Weight 59'
REPW60	= 'Replicate Weight 60'
REPW61	= 'Replicate Weight 61'
REPW62	= 'Replicate Weight 62'
REPW63	= 'Replicate Weight 63'
REPW64	= 'Replicate Weight 64'
REPW65	= 'Replicate Weight 65'
REPW66	= 'Replicate Weight 66'
REPW67	= 'Replicate Weight 67'
REPW68	= 'Replicate Weight 68'
REPW69	= 'Replicate Weight 69'
REPW70	= 'Replicate Weight 70'
REPW71	= 'Replicate Weight 71'
REPW72	= 'Replicate Weight 72'
REPW73	= 'Replicate Weight 73'
REPW74	= 'Replicate Weight 74'
REPW75	= 'Replicate Weight 75'
REPW76	= 'Replicate Weight 76'
REPW77	= 'Replicate Weight 77'
REPW78	= 'Replicate Weight 78'
REPW79	= 'Replicate Weight 79'
REPW80	= 'Replicate Weight 80'
REPW81	= 'Replicate Weight 81'
REPW82	= 'Replicate Weight 82'
REPW83	= 'Replicate Weight 83'
REPW84	= 'Replicate Weight 84'
REPW85	= 'Replicate Weight 85'
REPW86	= 'Replicate Weight 86'
REPW87	= 'Replicate Weight 87'
REPW88	= 'Replicate Weight 88'
F_P135	= 'Imputation Flag For P135'
F_P140	= 'Imputation Flag For P140'
F_P145	= 'Imputation Flag For P145'
F_P150	= 'Imputation Flag For P150'
F_P155	= 'Imputation Flag For P155'
F_P160	= 'Imputation Flag For P160'
F_P165	= 'Imputation Flag For P165'
F_P170	= 'Imputation Flag For P170'
F_P175	= 'Imputation Flag For P175'
F_P180	= 'Imputation Flag For P180'
F_P185	= 'Imputation Flag For P185'
F_P190	= 'Imputation Flag For P190'
F_P195	= 'Imputation Flag For P195'
F_P200	= 'Imputation Flag For P200'
F_P205	= 'Imputation Flag For P205'
F_P210	= 'Imputation Flag For P210'
F_P215	= 'Imputation Flag For P215'
F_P220	= 'Imputation Flag For P220'
F_P225	= 'Imputation Flag For P225'
F_P230	= 'Imputation Flag For P230'
F_P235	= 'Imputation Flag For P235'
F_P240	= 'Imputation Flag For P240'
F_P245	= 'Imputation Flag For P245'
F_P250	= 'Imputation Flag For P250'
F_P255	= 'Imputation Flag For P255'
F_P260	= 'Imputation Flag For P260'
F_P265	= 'Imputation Flag For P265'
F_P270	= 'Imputation Flag For P270'
F_P275	= 'Imputation Flag For P275'
F_P280	= 'Imputation Flag For P280'
F_P285	= 'Imputation Flag For P285'
F_P290	= 'Imputation Flag For P290'
F_P295	= 'Imputation Flag For P295'
F_P300	= 'Imputation Flag For P300'
F_P305	= 'Imputation Flag For P305'
F_P310	= 'Imputation Flag For P310'
F_P315	= 'Imputation Flag For P315'
F_P320	= 'Imputation Flag For P320'
F_P325	= 'Imputation Flag For P325'
F_P330	= 'Imputation Flag For P330'
F_P335	= 'Imputation Flag For P335'
F_P340	= 'Imputation Flag For P340'
F_P345	= 'Imputation Flag For P345'
F_P350	= 'Imputation Flag For P350'
F_P360	= 'Imputation Flag For P360'
F_P361	= 'Imputation Flag For P361'
F_P365	= 'Imputation Flag For P365'
F_P370	= 'Imputation Flag For P370'
F_P385	= 'Imputation Flag For P385'
F_P390	= 'Imputation Flag For P390'
F_P395	= 'Imputation Flag For P395'
F_P400	= 'Imputation Flag For P400'
F_P405	= 'Imputation Flag For P405'
F_P410	= 'Imputation Flag For P410'
F_P415	= 'Imputation Flag For P415'
F_P420	= 'Imputation Flag For P420'
F_P425	= 'Imputation Flag For P425'
F_P430	= 'Imputation Flag For P430'
F_P435	= 'Imputation Flag For P435'
F_P440	= 'Imputation Flag For P440'
F_P445	= 'Imputation Flag For P445'
F_P450	= 'Imputation Flag For P450'
F_P455	= 'Imputation Flag For P455'
F_P460	= 'Imputation Flag For P460'
F_P465	= 'Imputation Flag For P465'
F_P467	= 'Imputation Flag For P467'
F_P470	= 'Imputation Flag For P470'
F_P475	= 'Imputation Flag For P475'
F_P480	= 'Imputation Flag For P480'
F_P485	= 'Imputation Flag For P485'
F_P490	= 'Imputation Flag For P490'
F_P492	= 'Imputation Flag For P492'
F_P495	= 'Imputation Flag For P495'
F_P500	= 'Imputation Flag For P500'
F_P505	= 'Imputation Flag For P505'
F_P510	= 'Imputation Flag For P510'
F_P515	= 'Imputation Flag For P515'
F_P520	= 'Imputation Flag For P520'
F_P525	= 'Imputation Flag For P525'
F_P530	= 'Imputation Flag For P530'
F_P535	= 'Imputation Flag For P535'
F_P540	= 'Imputation Flag For P540'
F_P545	= 'Imputation Flag For P545'
F_P550	= 'Imputation Flag For P550'
F_P555	= 'Imputation Flag For P555'
F_P560	= 'Imputation Flag For P560'
F_P565	= 'Imputation Flag For P565'
F_P570	= 'Imputation Flag For P570'
F_P575	= 'Imputation Flag For P575'
F_P580	= 'Imputation Flag For P580'
F_P585	= 'Imputation Flag For P585'
F_P590	= 'Imputation Flag For P590'
F_P595	= 'Imputation Flag For P595'
F_P600	= 'Imputation Flag For P600'
F_P602	= 'Imputation Flag For P602'
F_P605	= 'Imputation Flag For P605'
F_P610	= 'Imputation Flag For P610'
F_P615	= 'Imputation Flag For P615'
F_P620	= 'Imputation Flag For P620'
F_P622	= 'Imputation Flag For P622'
F_P625	= 'Imputation Flag For P625'
F_P630	= 'Imputation Flag For P630'
F_P635	= 'Imputation Flag For P635'
F_P640	= 'Imputation Flag For P640'
F_P645	= 'Imputation Flag For P645'
F_P650	= 'Imputation Flag For P650'
F_P655	= 'Imputation Flag For P655'
F_P660	= 'Imputation Flag For P660';

if _ERROR_ then call symputx('_EFIERR_',1);  /* set ERROR detection macro variable */

run;

Proc Format;
Value Fipsf 
	     		1 ="1 Alabama"
				2 ="2 Alaska"
				4 ="4 Arizona"
				5 ="5 Arkansas"
				6 ="6 California"
				8 ="8 Colorado"
				9 ="9 Connecticut"
				10 ="10 Delaware"
				11 ="11 District of Columbia"
				12 ="12 Florida"
				13 ="13 Georgia"
				15 ="15 Hawaii"
				16 ="16 Idaho"
				17 ="17 Illinois"
				18 ="18 Indiana"
				19 ="19 Iowa"
				20 ="20 Kansas"
				21 ="21 Kentucky"
				22 ="22 Louisiana"
				23 ="23 Maine"
				24 ="24 Maryland"
				25 ="25 Massachusetts"
				26 ="26 Michigan"
				27 ="27 Minnesota"
				28 ="28 Mississippi"
				29 ="29 Missouri"
				30 ="30 Montana"
				31 ="31 Nebraska"
				32 ="32 Nevada"
				33 ="33 New Hampshire"
				34 ="34 New Jersey"
				35 ="35 New Mexico"
				36 ="36 New York"
				37 ="37 North Carolina"
				38 ="38 North Dakota"
				39 ="39 Ohio"
				40 ="40 Oklahoma"
				41 ="41 Oregon"
				42 ="42 Pennsylvania"
				44 ="44 Rhode Island"
				45 ="45 South Carolina"
				46 ="46 South Dakota"
				47 ="47 Tennessee"
				48 ="48 Texas"
				49 ="49 Utah"
				50 ="50 Vermont"
				51 ="51 Virginia"
				53 ="53 Washington"
				54 ="54 West Virginia"
				55 ="55 Wisconsin"
				56 ="56 Wyoming";

 Value $Stabbr
  				"AL" ="AL Alabama"
				"AK" ="AK Alaska"
				"AZ" ="AZ Arizona"
				"AR" ="AR Arkansas"
				"CA" ="CA California"
				"CO" ="CO Colorado"
				"CT" ="CT Connecticut"
				"DE" ="DE Delaware"
				"DC" ="DC District of Columbia"
				"FL" ="FL Florida"
				"GA" ="GA Georgia"
				"HI" ="HI Hawaii"
				"ID" ="ID Idaho"
				"IL" ="IL Illinois"
				"IN" ="IN Indiana"
				"IA" ="IA Iowa"
				"KS" ="KS Kansas"
				"KY" ="KY Kentucky"
				"LA" ="LA Louisiana"
				"ME" ="ME Maine"
				"MD" ="MD Maryland"
				"MA" ="MA Massachusetts"
				"MI" ="MI Michigan"
				"MN" ="MN Minnesota"
				"MS" ="MS Mississippi"
				"MO" ="MO Missouri"
				"MT" ="MT Montana"
				"NE" ="NE Nebraska"
				"NV" ="NV Nevada"
				"NH" ="NH New Hampshire"
				"NJ" ="NJ New Jersey"
				"NM" ="NM New Mexico"
				"NY" ="NY New York"
				"NC" ="NC North Carolina"
				"ND" ="ND North Dakota"
				"OH" ="OH Ohio"
				"OK" ="OK Oklahoma"
				"OR" ="OR Oregon"
				"PA" ="PA Pennsylvania"
				"RI" ="RI Rhode Island"
				"SC" ="SC South Carolina"
				"SD" ="SD South Dakota"
				"TN" ="TN Tennessee"
				"TX" ="TX Texas"
				"UT" ="UT Utah"
				"VT" ="VT Vermont"
				"VA" ="VA Virginia"
				"WA" ="WA Washington"
				"WV" ="WV West Virginia"
				"WI" ="WI Wisconsin"
				"WY" ="WY Wyoming";

Value P335f  	1='Yes'
             	2='No, all-female school'
             	3='No, all-male school';

Value P365f     0='Not offer KG, Transitional KG, or Transitional 1st grade'
				1='Full day'
				2='Half day'
				3='Both offered';

Value P415f  	1='Reg. Elementary or Secondary'
             	2='Montessori'
             	3='Special Program Emphasis'
             	4='Special Education'
             	5='Vocational/Technical'
             	6='Alternative'
             	7='Early Childhood Program/Day Care Center';

Value P445f		1='Parochial(or inter-parochial'
				2='Diocesan'
				3='Private';

Value Commtyf  	1='Central City'
               	2='Urban fringe or large town'
               	3='Rural or small town';

Value $Framef	'list'=	'School is part of list frame'
                'area'=	'School is part of area frame';

Value higrf     1='All Ungraded'
                2='Prekindergarten'
                3='Kindergarten'
                4='Transitional kindergarten'
                5='Transitional first grade'
                6='1st grade'
    		   	7='2nd grade'
              	8='3rd grade '
              	9='4th grade'
             	10='5th grade'
             	11='6th grade'
             	12='7th grade'
             	13='8th grade'
             	14='9th grade'
             	15='10th grade'
             	16='11th grade'
             	17='12th grade';

Value Levelf 	1='Elementary'
             	2='Secondary'
             	3='Combined elementary and secondary';


Value Localef 	1='Large central city'  
             	2='Mid-size central city'  
             	3='Urban fringe of large city' 
				4='Urban Fringe of mid-size city'  
				5='Large town'  
				6='Small town'  
				7='Rural - outside MSA'  
				8='Rural - inside MSA'; 

Value logrf     1='All Ungraded'
                2='Prekindergarten'
                3='Kindergarten'
                4='Transitional kindergarten'
                5='Transitional first grade'
                6='1st grade'
    		   	7='2nd grade'
              	8='3rd grade '
              	9='4th grade'
             	10='5th grade'
             	11='6th grade'
             	12='7th grade'
             	13='8th grade'
             	14='9th grade'
             	15='10th grade'
             	16='11th grade'
             	17='12th grade';

Value Orientf  	1='Roman Catholic'
               	2='African Methodist Episcopal'
             	3='Amish'
             	4='Assembly of God'
             	5='Baptist'
             	6='Brethren'
             	7='Calvinist'
             	8='Christian (no specific denomination)'
             	9='Church of Christ'
            	10='Church of God'
            	11='Church of God in Christ'
            	12='Disciples of Christ'
            	13='Episcopal'
            	14='Friends'
            	15='Greek Orthodox'
            	16='Islamic'
            	17='Jewish'
            	18='Latter Day Saints'
            	19='Lutheran Church - Missouri Synod'
            	20='Evangelical Lutheran Church in America'
            	21='Wisconsin Evangelical Lutheran Synod'
            	22='Other Lutheran'
            	23='Mennonite'
            	24='Methodist'
            	25='Pentecostal'
            	26='Presbyterian'
            	27='Seventh-Day Adventist'
            	28='Other'
            	29='Nonsectarian';

Value Perminf 	1='None'
              	2='1-9 percent'
              	3='10-29 percent'
              	4='30-49 percent'
              	5='50 percent or more';

Value Regionf 	1='Northeast'
              	2='Midwest'
              	3='South'
              	4='West';

Value Religf 	1='Catholic'
             	2='Other religious'
             	3='Nonsectarian';

Value Sizef  	1='Less than 50 students'
             	2='50 to 149 students'
             	3='150 to 299 students'
             	4='300 to 499 students'
             	5='500 to 749 students'
             	6='750 or more';

Value Tabflgf  	1='Schools offering ungraded or grade 1 or above'
             	2='Schools offering no grade higher than KG';

Value Typof   	1='Catholic, parochial'
 			 	2='Catholic, diocesan'
			 	3='Catholic, private'
			 	4='Other religious, conservative Christian'
			 	5='Other religious, affiliated'
			 	6='Other religious, not affiliated'
			 	7='Nonsectarian, regular school'
			 	8='Nonsectarian, special program'
			 	9='Nonsectarian, special education';

Value Imputf 	0='Not imputed  (original data)'
 			 	1='Ratio adjustment of original data'
			 	2='Imputed -- data from other variables'
			 	3='Imputed -- donor value from another record'
			 	4='Clerical imputation';
Run;

*******************************************************************;
*** The following lines of code have been commented out. If the ***;
*** user should wish to run file frequencies, or proc contents  ***;
*** they may submit these lines separtely or remove the "/*"    ***;
*** and "*/" characters before running this code. User may also ***;
*** wish to comment out the final school weight when running    ***;
*** frequency code.                                             ***;
*******************************************************************;
/*

*** Frequencies of Categorical Variables ***;

Proc Freq Data=OUT1.PSS0304_PU;
Table SSTABB SSTFIPS P335 P365 P415 P445 COMMTYPE FRAME HIGR2004 
LEVEL LOCALE LOGR2004 ORIENT PERMINOR REGION RELIG SIZE TABFLAG 
TYPOLOGY F_P135 F_P140 F_P145 F_P150 F_P155 F_P160 F_P165 F_P170
F_P175 F_P180 F_P185 F_P190 F_P195 F_P200 F_P205 F_P210
F_P215 F_P220 F_P225 F_P230 F_P235 F_P240 F_P245 F_P250
F_P255 F_P260 F_P265 F_P270 F_P275 F_P280 F_P285 F_P290
F_P295 F_P300 F_P305 F_P310 F_P315 F_P320 F_P325 F_P330
F_P335 F_P340 F_P345 F_P350 F_P360 F_P361 F_P362
F_P365 F_P370 F_P385 F_P390 F_P395 F_P400 F_P405 F_P410
F_P415 F_P420 F_P425 F_P430 F_P435 F_P440 F_P445 F_P450
F_P455 F_P460 F_P465 F_P467 F_P470 F_P475 F_P480 F_P485
F_P490 F_P495 F_P500 F_P505 F_P510 F_P515 F_P520 F_P525
F_P530 F_P535 F_P540 F_P545 F_P550 F_P555 F_P560 F_P565
F_P570 F_P575 F_P580 F_P585 F_P590 F_P595 F_P600 F_P602
F_P605 F_P610 F_P615 F_P620 F_P622 F_P625 F_P630 F_P635
F_P640 F_P645 F_P650 F_P655 F_P660/Missing;
Format SSTABB $STABBR. SSTFIPS FIPSF. P335 P335F. P365 P365f. 
P415 P415F. P445 P445f. COMMTYPE COMMTYF. FRAME $FRAMEF. 
HIGR2004 HIGRF. LEVEL LEVELF. LOCALE LOCALEF. 
LOGR2004 LOGRF. ORIENT ORIENTF. PERMINOR PERMINF. REGION REGIONF. 
RELIG RELIGF. SIZE SIZEF. TABFLAG TABFLGF. TYPOLOGY TYPOF. 
F_P135 F_P140 F_P145 F_P150 F_P155 F_P160 F_P165 F_P170
F_P175 F_P180 F_P185 F_P190 F_P195 F_P200 F_P205 F_P210
F_P215 F_P220 F_P225 F_P230 F_P235 F_P240 F_P245 F_P250
F_P255 F_P260 F_P265 F_P270 F_P275 F_P280 F_P285 F_P290
F_P295 F_P300 F_P305 F_P310 F_P315 F_P320 F_P325 F_P330
F_P335 F_P340 F_P345 F_P350 F_P360 F_P361 F_P362
F_P365 F_P370 F_P385 F_P390 F_P395 F_P400 F_P405 F_P410
F_P415 F_P420 F_P425 F_P430 F_P435 F_P440 F_P445 F_P450
F_P455 F_P460 F_P465 F_P467 F_P470 F_P475 F_P480 F_P485
F_P490 F_P495 F_P500 F_P505 F_P510 F_P515 F_P520 F_P525
F_P530 F_P535 F_P540 F_P545 F_P550 F_P555 F_P560 F_P565
F_P570 F_P575 F_P580 F_P585 F_P590 F_P595 F_P600 F_P602
F_P605 F_P610 F_P615 F_P620 F_P622 F_P625 F_P630 F_P635
F_P640 F_P645 F_P650 F_P655 F_P660 IMPUTF.;
*WEIGHT SFNLWT; 
Title 'Frequencies of Categorical Variables: PSS 2003-2004';
Run;

*** Data File Contents ***;

PROC CONTENTS DATA=OUT1.PSS0304_PU Varnum;
Title 'PRIVATE SCHOOL SURVEY, 2003-2004';
RUN;

*/

